/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.complexity;

import de.firemage.autograder.core.CodePosition;
import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import spoon.reflect.code.CtSynchronized;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtModifiable;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.visitor.CtScanner;
import spoon.reflect.visitor.CtVisitor;
import spoon.support.reflect.CtExtendedModifier;

@ExecutableCheck(reportedProblems={ProblemType.MULTI_THREADING})
public class MultiThreading
extends IntegratedCheck {
    @Override
    protected void check(StaticAnalysis staticAnalysis) {
        staticAnalysis.getModel().getRootPackage().accept((CtVisitor)new CtScanner(){

            public void visitCtSynchronized(CtSynchronized ctSynchronized) {
                if (ctSynchronized.isImplicit() || !ctSynchronized.getPosition().isValidPosition()) {
                    super.visitCtSynchronized(ctSynchronized);
                    return;
                }
                MultiThreading.this.addLocalProblem((CtElement)ctSynchronized.getExpression(), new LocalizedMessage("multi-threading"), ProblemType.MULTI_THREADING);
                super.visitCtSynchronized(ctSynchronized);
            }

            protected void enter(CtElement ctElement) {
                if (!ctElement.isImplicit() && ctElement.getPosition().isValidPosition() && ctElement instanceof CtModifiable) {
                    CtModifiable ctModifiable = (CtModifiable)ctElement;
                    for (CtExtendedModifier modifier : ctModifiable.getExtendedModifiers()) {
                        if (modifier.isImplicit() || !modifier.getPosition().isValidPosition() || modifier.getKind() != ModifierKind.SYNCHRONIZED) continue;
                        MultiThreading.this.addLocalProblem(CodePosition.fromSourcePosition(modifier.getPosition(), ctElement, MultiThreading.this.getRoot()), new LocalizedMessage("multi-threading"), ProblemType.MULTI_THREADING);
                    }
                }
            }
        });
    }
}

