/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.comment;

import de.firemage.autograder.api.Translatable;
import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import spoon.processing.AbstractProcessor;
import spoon.reflect.code.CtComment;
import spoon.reflect.code.CtStatement;
import spoon.reflect.declaration.CtElement;

@ExecutableCheck(reportedProblems={ProblemType.UNNECESSARY_COMMENT})
public class UnnecessaryComment
extends IntegratedCheck {
    private final Set<CtComment> visitedComments = Collections.newSetFromMap(new IdentityHashMap());

    private void checkComments(Collection<? extends CtComment> comments) {
        this.visitedComments.addAll(comments);
        if (comments.size() != 1) {
            return;
        }
        for (CtComment ctComment : comments) {
            if (!ctComment.getContent().isBlank()) continue;
            this.addLocalProblem((CtElement)ctComment, (Translatable)new LocalizedMessage("unnecessary-comment-empty"), ProblemType.UNNECESSARY_COMMENT);
            break;
        }
    }

    private static boolean isStandaloneComment(CtComment ctComment) {
        CtElement parent = ctComment.getParent();
        if (parent == null) {
            return false;
        }
        return !parent.getComments().contains(ctComment);
    }

    @Override
    protected void check(StaticAnalysis staticAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtElement>(){

            public void process(CtElement element) {
                CtComment ctComment;
                if (element.isImplicit() || !element.getPosition().isValidPosition()) {
                    return;
                }
                if (element instanceof CtComment && UnnecessaryComment.isStandaloneComment(ctComment = (CtComment)element) && !UnnecessaryComment.this.visitedComments.contains(ctComment)) {
                    List followingComments = SpoonUtil.getNextStatements((CtStatement)ctComment).stream().takeWhile(CtComment.class::isInstance).map(CtComment.class::cast).collect(Collectors.toCollection(ArrayList::new));
                    followingComments.add(0, ctComment);
                    UnnecessaryComment.this.checkComments(followingComments);
                    return;
                }
                if (!element.getComments().isEmpty()) {
                    UnnecessaryComment.this.checkComments(element.getComments());
                }
            }
        });
    }
}

