/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.comment;

import de.firemage.autograder.api.Translatable;
import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import spoon.processing.AbstractProcessor;
import spoon.reflect.code.CtJavaDoc;
import spoon.reflect.code.CtJavaDocTag;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtParameter;

@ExecutableCheck(reportedProblems={ProblemType.JAVADOC_MISSING_PARAMETER_TAG, ProblemType.JAVADOC_UNKNOWN_PARAMETER_TAG, ProblemType.JAVADOC_UNEXPECTED_TAG})
public class MethodJavadocCheck
extends IntegratedCheck {
    private static final List<CtJavaDocTag.TagType> VALID_TAGS = List.of(CtJavaDocTag.TagType.PARAM, CtJavaDocTag.TagType.RETURN, CtJavaDocTag.TagType.THROWS, CtJavaDocTag.TagType.EXCEPTION, CtJavaDocTag.TagType.SEE, CtJavaDocTag.TagType.UNKNOWN, CtJavaDocTag.TagType.DEPRECATED);

    @Override
    protected void check(StaticAnalysis staticAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtMethod<?>>(){

            public void process(CtMethod<?> method) {
                if (method.isPrivate()) {
                    return;
                }
                Optional<CtJavaDoc> javadoc = SpoonUtil.getJavadoc(method);
                if (javadoc.isEmpty()) {
                    return;
                }
                MethodJavadocCheck.this.checkParameters(method, javadoc.get());
                MethodJavadocCheck.this.checkValidTags(javadoc.get());
            }
        });
    }

    private boolean hasTypeParameter(String name, CtMethod<?> method) {
        return method.getFormalCtTypeParameters().stream().anyMatch(param -> name.equals("<" + param.getSimpleName() + ">"));
    }

    private boolean hasParameter(String name, CtMethod<?> method) {
        return method.getParameters().stream().anyMatch(param -> param.getSimpleName().equals(name));
    }

    private void checkParameters(CtMethod<?> method, CtJavaDoc javadoc) {
        List<String> paramTags = javadoc.getTags().stream().filter(tag -> tag.getType() == CtJavaDocTag.TagType.PARAM).map(CtJavaDocTag::getParam).map(String::trim).toList();
        for (CtParameter param : method.getParameters()) {
            if (paramTags.contains(param.getSimpleName())) continue;
            this.addLocalProblem((CtElement)javadoc, (Translatable)new LocalizedMessage("javadoc-method-exp-param-missing", Map.of("param", param.getSimpleName())), ProblemType.JAVADOC_MISSING_PARAMETER_TAG);
        }
        for (String tag2 : paramTags) {
            if (this.hasParameter(tag2, method) || this.hasTypeParameter(tag2, method)) continue;
            this.addLocalProblem((CtElement)javadoc, (Translatable)new LocalizedMessage("javadoc-method-exp-param-unknown", Map.of("param", tag2)), ProblemType.JAVADOC_UNKNOWN_PARAMETER_TAG);
        }
    }

    private void checkValidTags(CtJavaDoc javadoc) {
        for (CtJavaDocTag tag : javadoc.getTags()) {
            if (VALID_TAGS.contains(tag.getType())) continue;
            this.addLocalProblem((CtElement)javadoc, (Translatable)new LocalizedMessage("javadoc-unexpected-tag", Map.of("tag", tag.getType().getName())), ProblemType.JAVADOC_UNEXPECTED_TAG);
        }
    }
}

