/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.comment;

import de.firemage.autograder.api.Translatable;
import de.firemage.autograder.core.CodePosition;
import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.file.SourcePath;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import spoon.processing.AbstractProcessor;
import spoon.reflect.code.CtComment;
import spoon.reflect.cu.SourcePosition;

@ExecutableCheck(reportedProblems={ProblemType.COMMENTED_OUT_CODE})
public class CommentedOutCodeCheck
extends IntegratedCheck {
    private static final Comparator<SourcePosition> POSITION_COMPARATOR = Comparator.comparingInt(SourcePosition::getSourceStart);
    private static final Translatable MESSAGE = new LocalizedMessage("commented-out-code");
    private static final Set<CtComment.CommentType> ALLOWED_COMMENT_TYPES = Set.of(CtComment.CommentType.BLOCK, CtComment.CommentType.INLINE);

    @Override
    protected void check(StaticAnalysis staticAnalysis) {
        final HashMap<Path, SortedSet> files = new HashMap<Path, SortedSet>();
        staticAnalysis.processWith(new AbstractProcessor<CtComment>(){

            public void process(CtComment comment) {
                if (!ALLOWED_COMMENT_TYPES.contains(comment.getCommentType())) {
                    return;
                }
                String content = comment.getContent().trim();
                if (StringUtils.containsAny((CharSequence)content, (char[])new char[]{';', '{', '}', '='})) {
                    SourcePosition position = comment.getPosition();
                    files.computeIfAbsent(position.getFile().toPath(), path -> new TreeSet<SourcePosition>(POSITION_COMPARATOR)).add(position);
                }
            }
        });
        files.forEach((path, positions) -> {
            SourcePath sourcePath = this.getRoot().getCompilationUnit((Path)path).path();
            Iterator<SourcePosition> iter = positions.iterator();
            if (!iter.hasNext()) {
                return;
            }
            RunningPosition running = new RunningPosition((SourcePosition)iter.next());
            iter.forEachRemaining(position -> {
                int line = position.getLine();
                int column = position.getColumn();
                if (line == running.endLine) {
                    running.endColumn = position.getEndColumn();
                } else if (line == running.endLine + 1 && column == running.startColumn) {
                    running.endLine = position.getEndLine();
                    running.endColumn = position.getEndColumn();
                } else {
                    running.addProblem(sourcePath);
                    running.startLine = line;
                    running.startColumn = column;
                    running.endLine = position.getEndLine();
                    running.endColumn = position.getEndColumn();
                }
            });
            running.addProblem(sourcePath);
        });
    }

    private final class RunningPosition {
        int startLine;
        int endLine;
        int startColumn;
        int endColumn;

        RunningPosition(SourcePosition position) {
            this.startLine = position.getLine();
            this.endLine = position.getEndLine();
            this.startColumn = position.getColumn();
            this.endColumn = position.getEndColumn();
        }

        void addProblem(SourcePath path) {
            CommentedOutCodeCheck.this.addLocalProblem(new CodePosition(CommentedOutCodeCheck.this.getRoot(), path, this.startLine, this.endLine, this.startColumn, this.endColumn), MESSAGE, ProblemType.COMMENTED_OUT_CODE);
        }
    }
}

