/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.api;

import de.firemage.autograder.api.Translatable;
import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import java.util.List;
import java.util.Map;
import java.util.Set;
import spoon.processing.AbstractProcessor;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtIf;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.code.CtVariableWrite;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.reference.CtVariableReference;

@ExecutableCheck(reportedProblems={ProblemType.USE_MODULO_OPERATOR})
public class UseModuloOperator
extends IntegratedCheck {
    private static final Set<BinaryOperatorKind> ALLOWED_OPERATORS = Set.of(BinaryOperatorKind.LT, BinaryOperatorKind.LE, BinaryOperatorKind.GE, BinaryOperatorKind.GT, BinaryOperatorKind.EQ);

    private void checkModulo(CtIf ctIf) {
        CtVariableAccess ctVariableAccess;
        Integer integer;
        CtLiteral ctLiteral;
        CtBinaryOperator ctBinaryOperator;
        CtVariableWrite ctVariableWrite;
        CtAssignment thenAssignment;
        block8: {
            block7: {
                CtStatement ctStatement;
                List<CtStatement> thenBlock = SpoonUtil.getEffectiveStatements(ctIf.getThenStatement());
                if (ctIf.getElseStatement() != null || thenBlock.size() != 1 || !((ctStatement = thenBlock.get(0)) instanceof CtAssignment) || !((ctStatement = (thenAssignment = (CtAssignment)ctStatement).getAssigned()) instanceof CtVariableWrite)) break block7;
                ctVariableWrite = (CtVariableWrite)ctStatement;
                ctStatement = ctIf.getCondition();
                if (ctStatement instanceof CtBinaryOperator && ALLOWED_OPERATORS.contains((ctBinaryOperator = (CtBinaryOperator)ctStatement).getKind())) break block8;
            }
            return;
        }
        Object object = SpoonUtil.resolveCtExpression(thenAssignment.getAssignment());
        if (!(object instanceof CtLiteral) || !((object = (ctLiteral = (CtLiteral)object).getValue()) instanceof Integer) || (integer = (Integer)object) != 0) {
            return;
        }
        CtVariableReference assignedVariable = ctVariableWrite.getVariable();
        CtBinaryOperator condition = SpoonUtil.normalizeBy((left, right) -> {
            CtVariableAccess ctVariableAccess;
            return right instanceof CtVariableAccess && (ctVariableAccess = (CtVariableAccess)right).getVariable().equals(assignedVariable);
        }, ctBinaryOperator);
        CtExpression ctExpression = condition.getLeftHandOperand();
        if (!(ctExpression instanceof CtVariableAccess) || !(ctVariableAccess = (CtVariableAccess)ctExpression).getVariable().equals(assignedVariable)) {
            return;
        }
        CtExpression checkedValue = condition.getRightHandOperand();
        if (SpoonUtil.isNullLiteral(checkedValue)) {
            return;
        }
        if (Set.of(BinaryOperatorKind.GE, BinaryOperatorKind.EQ).contains(condition.getKind())) {
            this.addLocalProblem((CtElement)ctIf, (Translatable)new LocalizedMessage("common-reimplementation", Map.of("suggestion", "%s %%= %s".formatted(assignedVariable, checkedValue))), ProblemType.USE_MODULO_OPERATOR);
        }
    }

    @Override
    protected void check(StaticAnalysis staticAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtIf>(){

            public void process(CtIf ctIf) {
                if (ctIf.isImplicit() || !ctIf.getPosition().isValidPosition() || ctIf.getThenStatement() == null) {
                    return;
                }
                UseModuloOperator.this.checkModulo(ctIf);
            }
        });
    }
}

