/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.api;

import de.firemage.autograder.api.Translatable;
import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import spoon.processing.AbstractProcessor;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldRead;
import spoon.reflect.code.CtNewArray;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtEnum;
import spoon.reflect.declaration.CtEnumValue;
import spoon.reflect.declaration.CtField;
import spoon.reflect.reference.CtTypeReference;

@ExecutableCheck(reportedProblems={ProblemType.COMMON_REIMPLEMENTATION_ADD_ENUM_VALUES})
public class UseEnumValues
extends IntegratedCheck {
    private static <T> boolean isOrderedCollection(CtTypeReference<T> ctTypeReference) {
        return Stream.of(List.class).map(ctClass -> ctTypeReference.getFactory().createCtTypeReference(ctClass)).anyMatch(arg_0 -> ctTypeReference.isSubtypeOf(arg_0));
    }

    public static boolean checkEnumValues(CtEnum<?> ctEnum, boolean isOrdered, Collection<? extends CtEnumValue<?>> enumValues) {
        ArrayList expectedValues = new ArrayList(ctEnum.getEnumValues());
        for (CtEnumValue<?> enumValue : enumValues) {
            if (isOrdered && !expectedValues.isEmpty() && !((CtEnumValue)expectedValues.get(0)).equals(enumValue)) {
                return false;
            }
            boolean wasPresent = expectedValues.remove(enumValue);
            if (wasPresent) continue;
            return false;
        }
        return expectedValues.isEmpty() && !enumValues.isEmpty();
    }

    private void checkListingEnumValues(boolean isOrdered, Iterable<? extends CtExpression<?>> ctExpressions, UnaryOperator<? super String> suggestion, CtElement span) {
        CtEnum<?> ctEnum = null;
        ArrayList addedValues = new ArrayList();
        for (CtExpression<?> ctExpression : ctExpressions) {
            CtEnumFieldRead enumFieldRead = CtEnumFieldRead.of(ctExpression).orElse(null);
            if (enumFieldRead == null) {
                return;
            }
            if (ctEnum == null) {
                ctEnum = enumFieldRead.ctEnum();
            } else if (!ctEnum.equals(enumFieldRead.ctEnum())) {
                return;
            }
            addedValues.add(enumFieldRead.ctEnumValue());
        }
        if (ctEnum != null && UseEnumValues.checkEnumValues(ctEnum, isOrdered, addedValues)) {
            this.addLocalProblem(span == null ? (CtElement)addedValues.get(addedValues.size() - 1) : span, (Translatable)new LocalizedMessage("common-reimplementation", Map.of("suggestion", suggestion.apply("%s.values()".formatted(ctEnum.getSimpleName())))), ProblemType.COMMON_REIMPLEMENTATION_ADD_ENUM_VALUES);
        }
    }

    @Override
    protected void check(StaticAnalysis staticAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtField<?>>(){

            public void process(CtField<?> ctField) {
                if (!SpoonUtil.isEffectivelyFinal(ctField)) {
                    return;
                }
                CtExpression ctExpression = ctField.getDefaultExpression();
                if (ctExpression == null || ctExpression.isImplicit() || !ctExpression.getPosition().isValidPosition()) {
                    return;
                }
                if (ctField.getType().isArray() && ctExpression instanceof CtNewArray) {
                    CtNewArray ctNewArray = (CtNewArray)ctExpression;
                    UseEnumValues.this.checkListingEnumValues(true, ctNewArray.getElements(), suggestion -> "Arrays.copyOf(%s, %s.length)".formatted(suggestion, suggestion), (CtElement)ctExpression);
                } else {
                    UseEnumValues.this.checkListingEnumValues(UseEnumValues.isOrderedCollection(ctExpression.getType()), SpoonUtil.getElementsOfExpression(ctExpression), suggestion -> "%s.of(%s)".formatted(ctExpression.getType().getSimpleName(), suggestion), (CtElement)ctExpression);
                }
            }
        });
    }

    public record CtEnumFieldRead(CtEnum<?> ctEnum, CtEnumValue<?> ctEnumValue) {
        public static Optional<CtEnumFieldRead> of(CtExpression<?> ctExpression) {
            CtEnumValue ctEnumValue;
            CtFieldRead ctFieldRead;
            CtField ctField;
            if (ctExpression.getType().equals(ctExpression.getFactory().Type().nullType())) {
                return Optional.empty();
            }
            if (!(ctExpression.getType().isEnum() && ctExpression instanceof CtFieldRead && (ctField = (ctFieldRead = (CtFieldRead)ctExpression).getVariable().getDeclaration()) instanceof CtEnumValue && (ctField = (ctEnumValue = (CtEnumValue)ctField).getDeclaringType()) instanceof CtEnum)) {
                return Optional.empty();
            }
            CtEnum ctEnum = (CtEnum)ctField;
            return Optional.of(new CtEnumFieldRead(ctEnum, ctEnumValue));
        }
    }
}

