/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.api;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import java.util.List;
import java.util.Map;
import spoon.processing.AbstractProcessor;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtForEach;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.filter.InvocationFilter;

@ExecutableCheck(reportedProblems={ProblemType.USE_ENTRY_SET})
public class UseEntrySet
extends IntegratedCheck {
    private static boolean hasInvokedKeySet(CtInvocation<?> ctInvocation) {
        return ctInvocation.getTarget() != null && ctInvocation.getExecutable() != null && SpoonUtil.isSubtypeOf(ctInvocation.getTarget().getType(), Map.class) && ctInvocation.getExecutable().getSimpleName().equals("keySet");
    }

    @Override
    protected void check(StaticAnalysis staticAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtForEach>(){

            public void process(CtForEach ctForEach) {
                CtInvocation ctInvocation;
                CtExpression ctExpression;
                if (!(!ctForEach.isImplicit() && ctForEach.getPosition().isValidPosition() && (ctExpression = SpoonUtil.resolveCtExpression(ctForEach.getExpression())) instanceof CtInvocation && UseEntrySet.hasInvokedKeySet(ctInvocation = (CtInvocation)ctExpression) && ctForEach.getExpression().getPosition().isValidPosition())) {
                    return;
                }
                CtLocalVariable loopVariable = ctForEach.getVariable();
                CtExecutableReference ctExecutableReference = ctInvocation.getFactory().createCtTypeReference(Map.class).getTypeDeclaration().getMethod("get", new CtTypeReference[]{ctInvocation.getFactory().createCtTypeReference(Object.class)}).getReference();
                List<CtInvocation> invocations = ctForEach.getBody().getElements((Filter)new InvocationFilter(ctExecutableReference)).stream().filter(invocation -> {
                    CtVariableAccess ctVariableAccess;
                    Object patt2735$temp;
                    return invocation.getTarget() != null && invocation.getTarget().equals(ctInvocation.getTarget()) && invocation.getArguments().size() == 1 && (patt2735$temp = invocation.getArguments().get(0)) instanceof CtVariableAccess && (ctVariableAccess = (CtVariableAccess)patt2735$temp).getVariable().equals(loopVariable.getReference());
                }).toList();
                if (!invocations.isEmpty()) {
                    UseEntrySet.this.addLocalProblem((CtElement)ctForEach.getExpression(), new LocalizedMessage("suggest-replacement", Map.of("original", "keySet()", "suggestion", "entrySet()")), ProblemType.USE_ENTRY_SET);
                }
            }
        });
    }
}

