/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.api;

import de.firemage.autograder.api.Translatable;
import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.integrated.ForLoopRange;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import de.firemage.autograder.core.integrated.UsesFinder;
import java.util.List;
import java.util.Map;
import spoon.processing.AbstractProcessor;
import spoon.reflect.code.CtArrayWrite;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldAccess;
import spoon.reflect.code.CtFor;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtNewArray;
import spoon.reflect.code.CtNewClass;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtVariable;

@ExecutableCheck(reportedProblems={ProblemType.COMMON_REIMPLEMENTATION_ARRAYS_FILL})
public class UseArraysFill
extends IntegratedCheck {
    private void checkArraysFill(CtFor ctFor) {
        CtLiteral ctLiteral;
        CtVariableRead index;
        CtArrayWrite ctArrayWrite;
        CtAssignment ctAssignment;
        CtStatement ctStatement;
        ForLoopRange forLoopRange = ForLoopRange.fromCtFor(ctFor).orElse(null);
        List<CtStatement> statements = SpoonUtil.getEffectiveStatements(ctFor.getBody());
        if (!(statements.size() == 1 && forLoopRange != null && (ctStatement = statements.get(0)) instanceof CtAssignment && (ctStatement = (ctAssignment = (CtAssignment)ctStatement).getAssigned()) instanceof CtArrayWrite && (ctStatement = (ctArrayWrite = (CtArrayWrite)ctStatement).getIndexExpression()) instanceof CtVariableRead && (index = (CtVariableRead)ctStatement).getVariable().equals(forLoopRange.loopVariable()))) {
            return;
        }
        CtVariable loopVariable = (CtVariable)SpoonUtil.getReferenceDeclaration(forLoopRange.loopVariable());
        if (UsesFinder.variableUses(loopVariable).nestedIn((CtElement)ctAssignment.getAssignment()).hasAny()) {
            return;
        }
        if (ctAssignment.getAssignment() instanceof CtNewClass || ctAssignment.getAssignment() instanceof CtNewArray) {
            return;
        }
        CtExpression rhs = ctAssignment.getAssignment();
        if (!SpoonUtil.isImmutable(rhs.getType())) {
            return;
        }
        String suggestion = "Arrays.fill(%s, %s, %s, %s)".formatted(ctArrayWrite.getTarget(), forLoopRange.start(), forLoopRange.end(), ctAssignment.getAssignment());
        CtExpression<Integer> ctExpression = forLoopRange.start();
        if (ctExpression instanceof CtLiteral && (Integer)(ctLiteral = (CtLiteral)ctExpression).getValue() == 0 && (ctExpression = forLoopRange.end()) instanceof CtFieldAccess) {
            CtFieldAccess fieldAccess = (CtFieldAccess)ctExpression;
            if (ctArrayWrite.getTarget().equals(fieldAccess.getTarget()) && fieldAccess.getVariable().getSimpleName().equals("length")) {
                suggestion = "Arrays.fill(%s, %s)".formatted(ctArrayWrite.getTarget(), ctAssignment.getAssignment());
            }
        }
        this.addLocalProblem((CtElement)ctFor, (Translatable)new LocalizedMessage("common-reimplementation", Map.of("suggestion", suggestion)), ProblemType.COMMON_REIMPLEMENTATION_ARRAYS_FILL);
    }

    @Override
    protected void check(StaticAnalysis staticAnalysis) {
        if (!staticAnalysis.hasJavaUtilImport()) {
            return;
        }
        staticAnalysis.processWith(new AbstractProcessor<CtFor>(){

            public void process(CtFor ctFor) {
                if (ctFor.isImplicit() || !ctFor.getPosition().isValidPosition()) {
                    return;
                }
                UseArraysFill.this.checkArraysFill(ctFor);
            }
        });
    }
}

