/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.api;

import de.firemage.autograder.api.Translatable;
import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.integrated.ForLoopRange;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import java.util.List;
import java.util.Map;
import spoon.processing.AbstractProcessor;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFor;
import spoon.reflect.code.CtOperatorAssignment;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.filter.VariableAccessFilter;

@ExecutableCheck(reportedProblems={ProblemType.COMMON_REIMPLEMENTATION_STRING_REPEAT})
public class StringRepeat
extends IntegratedCheck {
    private void checkStringRepeat(CtFor ctFor) {
        CtOperatorAssignment ctAssignment;
        ForLoopRange forLoopRange = ForLoopRange.fromCtFor(ctFor).orElse(null);
        List<CtStatement> statements = SpoonUtil.getEffectiveStatements(ctFor.getBody());
        if (statements.size() != 1 || forLoopRange == null) {
            return;
        }
        CtStatement ctStatement = statements.get(0);
        if (ctStatement instanceof CtOperatorAssignment && (ctAssignment = (CtOperatorAssignment)ctStatement).getKind() == BinaryOperatorKind.PLUS) {
            CtVariableAccess ctVariableAccess;
            CtExpression lhs = ctAssignment.getAssigned();
            if (!SpoonUtil.isTypeEqualTo(lhs.getType(), String.class)) {
                return;
            }
            CtExpression rhs = SpoonUtil.resolveCtExpression(ctAssignment.getAssignment());
            if (!ctAssignment.getElements((Filter)new VariableAccessFilter(forLoopRange.loopVariable())).isEmpty()) {
                return;
            }
            if (lhs instanceof CtVariableAccess && !rhs.getElements((Filter)new VariableAccessFilter((ctVariableAccess = (CtVariableAccess)lhs).getVariable())).isEmpty()) {
                return;
            }
            this.addLocalProblem((CtElement)ctFor, (Translatable)new LocalizedMessage("common-reimplementation", Map.of("suggestion", "%s += %s".formatted(lhs, rhs.getFactory().createInvocation(rhs.clone(), rhs.getFactory().Type().get(String.class).getMethod("repeat", new CtTypeReference[]{rhs.getFactory().createCtTypeReference(Integer.TYPE)}).getReference().clone(), new CtExpression[]{forLoopRange.length().clone()})))), ProblemType.COMMON_REIMPLEMENTATION_STRING_REPEAT);
        }
    }

    @Override
    protected void check(StaticAnalysis staticAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtFor>(){

            public void process(CtFor ctFor) {
                if (ctFor.isImplicit() || !ctFor.getPosition().isValidPosition()) {
                    return;
                }
                StringRepeat.this.checkStringRepeat(ctFor);
            }
        });
    }
}

