/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.api;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.integrated.ForLoopRange;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import spoon.processing.AbstractProcessor;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFor;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.filter.VariableAccessFilter;

@ExecutableCheck(reportedProblems={ProblemType.COLLECTIONS_N_COPIES})
public class CollectionsNCopies
extends IntegratedCheck {
    @Override
    protected void check(StaticAnalysis staticAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtFor>(){

            public void process(CtFor ctFor) {
                CtVariableRead ctVariableRead;
                CtInvocation ctInvocation;
                CtStatement ctStatement;
                if (ctFor.isImplicit() || !ctFor.getPosition().isValidPosition()) {
                    return;
                }
                ForLoopRange forLoopRange = ForLoopRange.fromCtFor(ctFor).orElse(null);
                List<CtStatement> statements = SpoonUtil.getEffectiveStatements(ctFor.getBody());
                if (!(statements.size() == 1 && forLoopRange != null && (ctStatement = statements.get(0)) instanceof CtInvocation && (ctInvocation = (CtInvocation)ctStatement).getExecutable().getSimpleName().equals("add") && ctInvocation.getArguments().size() == 1 && (ctStatement = ctInvocation.getTarget()) instanceof CtVariableRead && SpoonUtil.isSubtypeOf((ctVariableRead = (CtVariableRead)ctStatement).getType(), Collection.class))) {
                    return;
                }
                if (!ctFor.getBody().getElements((Filter)new VariableAccessFilter(forLoopRange.loopVariable())).isEmpty()) {
                    return;
                }
                CtExpression rhs = (CtExpression)ctInvocation.getArguments().get(0);
                if (!SpoonUtil.isImmutable(rhs.getType())) {
                    return;
                }
                CollectionsNCopies.this.addLocalProblem((CtElement)ctFor, new LocalizedMessage("common-reimplementation", Map.of("suggestion", "%s.addAll(Collections.nCopies(%s, %s))".formatted(ctVariableRead, forLoopRange.length(), rhs))), ProblemType.COLLECTIONS_N_COPIES);
            }
        });
    }
}

