/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.api;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.integrated.CtRange;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.Range;
import spoon.processing.AbstractProcessor;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtExpression;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.factory.Factory;
import spoon.reflect.reference.CtTypeReference;

@ExecutableCheck(reportedProblems={ProblemType.CHAR_RANGE})
public class CharRange
extends IntegratedCheck {
    private static final Set<BinaryOperatorKind> RANGE_OPERATORS = Set.of(BinaryOperatorKind.LT, BinaryOperatorKind.LE, BinaryOperatorKind.GT, BinaryOperatorKind.GE);
    private static final Map<Range<Character>, Suggester<Character, Boolean>> MAPPING = Map.of(Range.of((Comparable)Character.valueOf('a'), (Comparable)Character.valueOf('z')), (factory, ctExpression, targetType) -> factory.createBinaryOperator(SpoonUtil.createStaticInvocation(targetType, "isAlphabetic", SpoonUtil.castExpression(Integer.TYPE, ctExpression)), SpoonUtil.createStaticInvocation(targetType, "isLowerCase", SpoonUtil.castExpression(Character.TYPE, ctExpression)), BinaryOperatorKind.AND), Range.of((Comparable)Character.valueOf('A'), (Comparable)Character.valueOf('Z')), (factory, ctExpression, targetType) -> factory.createBinaryOperator(SpoonUtil.createStaticInvocation(targetType, "isAlphabetic", SpoonUtil.castExpression(Integer.TYPE, ctExpression)), SpoonUtil.createStaticInvocation(targetType, "isUpperCase", SpoonUtil.castExpression(Character.TYPE, ctExpression)), BinaryOperatorKind.AND), Range.of((Comparable)Character.valueOf('0'), (Comparable)Character.valueOf('9')), (factory, ctExpression, targetType) -> SpoonUtil.createStaticInvocation(targetType, "isDigit", SpoonUtil.castExpression(Character.TYPE, ctExpression)));

    private static Optional<CtExpression<Boolean>> makeSuggestion(CtExpression<Character> ctExpression, Range<Character> range) {
        return Optional.ofNullable(MAPPING.get(range)).map(fn -> fn.suggest(ctExpression.getFactory(), ctExpression, ctExpression.getFactory().Type().characterType()));
    }

    @Override
    protected void check(StaticAnalysis staticAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtBinaryOperator<Boolean>>(){

            public void process(CtBinaryOperator<Boolean> ctBinaryOperator) {
                CtBinaryOperator right;
                CtBinaryOperator left;
                boolean isNegated;
                block10: {
                    block9: {
                        if (ctBinaryOperator.isImplicit() || !ctBinaryOperator.getPosition().isValidPosition() || !SpoonUtil.isTypeEqualTo(ctBinaryOperator.getType(), Boolean.class, Boolean.TYPE)) {
                            return;
                        }
                        CtBinaryOperator operator = ctBinaryOperator;
                        if (ctBinaryOperator.getKind() == BinaryOperatorKind.OR) {
                            isNegated = true;
                            operator = (CtBinaryOperator)SpoonUtil.negate(ctBinaryOperator);
                        } else {
                            isNegated = false;
                            if (ctBinaryOperator.getKind() != BinaryOperatorKind.AND) {
                                return;
                            }
                        }
                        CtExpression ctExpression = operator.getLeftHandOperand();
                        if (!(ctExpression instanceof CtBinaryOperator)) break block9;
                        left = (CtBinaryOperator)ctExpression;
                        ctExpression = operator.getRightHandOperand();
                        if (!(ctExpression instanceof CtBinaryOperator)) break block9;
                        right = (CtBinaryOperator)ctExpression;
                        if (RANGE_OPERATORS.contains(left.getKind()) && RANGE_OPERATORS.contains(right.getKind())) break block10;
                    }
                    return;
                }
                CtRange leftRange = CtRange.ofCharRange((CtBinaryOperator<Boolean>)left).orElse(null);
                CtRange rightRange = CtRange.ofCharRange((CtBinaryOperator<Boolean>)right).orElse(null);
                if (leftRange == null || rightRange == null) {
                    return;
                }
                if (!leftRange.ctExpression().equals(rightRange.ctExpression())) {
                    return;
                }
                Range intersection = leftRange.toRange().intersectionWith(rightRange.toRange());
                CharRange.makeSuggestion(leftRange.ctExpression(), (Range<Character>)intersection).ifPresent(suggestion -> {
                    if (isNegated) {
                        suggestion = SpoonUtil.negate(suggestion);
                    }
                    CharRange.this.addLocalProblem((CtElement)ctBinaryOperator, new LocalizedMessage("common-reimplementation", Map.of("suggestion", suggestion)), ProblemType.CHAR_RANGE);
                });
            }
        });
    }

    @FunctionalInterface
    private static interface Suggester<T, R> {
        public CtExpression<R> suggest(Factory var1, CtExpression<T> var2, CtTypeReference<T> var3);

        default public CtExpression<R> suggest(CtExpression<T> ctExpression) {
            return this.suggest(ctExpression.getFactory(), ctExpression, ctExpression.getType());
        }
    }
}

