/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core;

import de.firemage.autograder.api.AbstractProblem;
import de.firemage.autograder.api.Translatable;
import de.firemage.autograder.core.CodePosition;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.Check;

public abstract class Problem
implements AbstractProblem {
    private final Check check;
    private final CodePosition position;
    private final Translatable explanation;
    private final ProblemType problemType;

    protected Problem(Check check, CodePosition position, Translatable explanation, ProblemType problemType) {
        this.check = check;
        this.position = position;
        this.explanation = explanation;
        this.problemType = problemType;
    }

    public String getDisplayLocation() {
        if (this.position.startLine() == this.position.endLine()) {
            return this.position.file() + ":" + this.position.startLine();
        }
        return this.position.file() + ":" + this.position.startLine() + "-" + this.position.endLine();
    }

    public Check getCheck() {
        return this.check;
    }

    public CodePosition getPosition() {
        return this.position;
    }

    public Translatable getExplanation() {
        return this.explanation;
    }

    public String getCheckName() {
        return this.check.getClass().getSimpleName();
    }

    public Translatable getLinterName() {
        return this.check.getLinter();
    }

    public String getType() {
        return this.problemType.toString();
    }

    public ProblemType getProblemType() {
        return this.problemType;
    }
}

