/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core;

import de.firemage.autograder.api.AbstractLinter;
import de.firemage.autograder.api.AbstractProblemType;
import de.firemage.autograder.api.CheckConfiguration;
import de.firemage.autograder.api.JavaVersion;
import de.firemage.autograder.api.LinterException;
import de.firemage.autograder.api.Translatable;
import de.firemage.autograder.core.CodeLinter;
import de.firemage.autograder.core.Problem;
import de.firemage.autograder.core.check.Check;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.file.TempLocation;
import de.firemage.autograder.core.file.UploadedFile;
import de.firemage.autograder.core.parallel.AnalysisResult;
import de.firemage.autograder.core.parallel.AnalysisScheduler;
import fluent.bundle.FluentBundle;
import fluent.bundle.FluentResource;
import fluent.functions.FluentFunctionFactory;
import fluent.functions.icu.ICUFunctionFactory;
import fluent.syntax.parser.FTLParser;
import fluent.syntax.parser.FTLStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.Scanners;

public final class Linter
implements AbstractLinter {
    private final int threads;
    private final TempLocation tempLocation;
    private final FluentBundle fluentBundle;
    private final ClassLoader classLoader;
    private final int maxProblemsPerCheck;
    private static final Collection<Class<?>> CHECKS = new LinkedHashSet(new Reflections("de.firemage.autograder.", new Scanner[]{Scanners.TypesAnnotated}).getTypesAnnotatedWith(ExecutableCheck.class));
    private static final Collection<Class<?>> CODE_LINTER = new LinkedHashSet(new Reflections("de.firemage.autograder.", new Scanner[]{Scanners.SubTypes}).getSubTypesOf(CodeLinter.class));

    public static Linter defaultLinter(Locale locale) {
        return new Linter(AbstractLinter.builder((Locale)locale));
    }

    public Linter(AbstractLinter.Builder builder) {
        Locale locale = builder.getLocale();
        String filename = switch (locale.getLanguage()) {
            case "de" -> "/strings.de.ftl";
            case "en" -> "/strings.en.ftl";
            default -> throw new IllegalArgumentException("No translation available for the locale " + locale);
        };
        try {
            FluentResource resource = FTLParser.parse((FTLStream)FTLStream.of((String)new String(this.getClass().getResourceAsStream(filename).readAllBytes(), StandardCharsets.UTF_8)));
            this.fluentBundle = FluentBundle.builder((Locale)locale, (FluentFunctionFactory)ICUFunctionFactory.INSTANCE).addResource(resource).build();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        this.tempLocation = builder.getTempLocation() != null ? (TempLocation)builder.getTempLocation() : TempLocation.random();
        this.threads = builder.getThreads();
        this.classLoader = builder.getClassLoader();
        this.maxProblemsPerCheck = builder.getMaxProblemsPerCheck();
    }

    public FluentBundle getFluentBundle() {
        return this.fluentBundle;
    }

    public List<Problem> checkFile(Path file, JavaVersion version, CheckConfiguration checkConfiguration, Consumer<Translatable> statusConsumer) throws LinterException, IOException {
        try (UploadedFile uploadedFile = UploadedFile.build(file, version, this.tempLocation, statusConsumer, this.classLoader);){
            List<Problem> list = this.checkFile(uploadedFile, checkConfiguration, statusConsumer);
            return list;
        }
    }

    public List<Problem> checkFile(UploadedFile file, CheckConfiguration checkConfiguration, Consumer<Translatable> statusConsumer) throws LinterException, IOException {
        List<Check> checks = this.findChecksForProblemTypes(checkConfiguration.problemsToReport());
        return this.checkFile(file, checkConfiguration, checks, statusConsumer);
    }

    public List<Problem> checkFile(UploadedFile file, CheckConfiguration checkConfiguration, Iterable<? extends Check> checks, Consumer<Translatable> statusConsumer) throws LinterException, IOException {
        List excludedClasses;
        AnalysisResult analysisResult;
        if (file == null) {
            return new ArrayList<Problem>();
        }
        IdentityHashMap<CodeLinter, List> linterChecks = new IdentityHashMap<CodeLinter, List>();
        List<CodeLinter<?>> codeLinters = this.findCodeLinter();
        block5: for (Check check : checks) {
            for (CodeLinter<?> linter : codeLinters) {
                if (!linter.supportedCheckType().isInstance(check)) continue;
                linterChecks.computeIfAbsent(linter, key -> new ArrayList()).add(check);
                continue block5;
            }
        }
        AnalysisScheduler scheduler = new AnalysisScheduler(this.threads, this.classLoader);
        try (TempLocation tempLinterLocation = this.tempLocation.createTempDirectory("linter");){
            for (Map.Entry entry : linterChecks.entrySet()) {
                CodeLinter linter = (CodeLinter)entry.getKey();
                Class targetCheckType = linter.supportedCheckType();
                List associatedChecks = Linter.castUnsafe((Iterable)entry.getValue(), targetCheckType);
                if (associatedChecks.isEmpty()) continue;
                scheduler.submitTask((s, reporter) -> reporter.reportProblems(linter.lint(file, tempLinterLocation, this.classLoader, associatedChecks, statusConsumer)));
            }
            analysisResult = scheduler.collectProblems();
            if (analysisResult.failed()) {
                throw new LinterException((Throwable)analysisResult.thrownException());
            }
        }
        List<Problem> unreducedProblems = analysisResult.problems();
        if (!checkConfiguration.problemsToReport().isEmpty()) {
            unreducedProblems = analysisResult.problems().stream().filter(problem -> checkConfiguration.problemsToReport().contains((Object)problem.getProblemType())).toList();
        }
        if ((excludedClasses = checkConfiguration.excludedClasses()) != null && !excludedClasses.isEmpty()) {
            unreducedProblems = unreducedProblems.stream().filter(problem -> !checkConfiguration.excludedClasses().contains(problem.getPosition().file().getName().replace(".java", ""))).toList();
        }
        return this.mergeProblems(unreducedProblems);
    }

    private List<Problem> mergeProblems(Collection<? extends Problem> unreducedProblems) {
        if (this.maxProblemsPerCheck == -1) {
            return new ArrayList<Problem>(unreducedProblems);
        }
        Map problems = unreducedProblems.stream().collect(Collectors.groupingBy(Problem::getCheck, LinkedHashMap::new, Collectors.toList()));
        ArrayList<Problem> result = new ArrayList<Problem>();
        for (Map.Entry entry : problems.entrySet()) {
            Check check = (Check)entry.getKey();
            List problemsForCheck = (List)entry.getValue();
            int targetNumberOfProblems = Math.min(this.maxProblemsPerCheck, ((Check)entry.getKey()).maximumProblems().orElse(this.maxProblemsPerCheck));
            if (problemsForCheck.size() > targetNumberOfProblems) {
                Map problemsByType = problemsForCheck.stream().collect(Collectors.groupingBy(Problem::getProblemType, LinkedHashMap::new, Collectors.toList()));
                problemsForCheck = problemsByType.values().stream().flatMap(list -> check.merge((List<Problem>)list, targetNumberOfProblems).stream()).collect(Collectors.toCollection(ArrayList::new));
            }
            result.addAll(problemsForCheck);
        }
        return result;
    }

    public String translateMessage(Translatable message) {
        String output = message.format(this.fluentBundle);
        if (output.startsWith("Unknown messageID '")) {
            throw new IllegalStateException(output);
        }
        return output;
    }

    public List<Check> findChecksForProblemTypes(Collection<? extends AbstractProblemType> problems) {
        return CHECKS.stream().filter(check -> this.isRequiredCheck(check.getAnnotation(ExecutableCheck.class), problems)).map(check -> {
            try {
                return (Check)check.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalStateException("Failed to instantiate check " + check.getName(), e);
            }
            catch (ClassCastException e) {
                throw new IllegalStateException(check.getName() + " does not inherit from Check");
            }
        }).toList();
    }

    public List<? extends CodeLinter<?>> findCodeLinter() {
        return CODE_LINTER.stream().map(linter -> {
            try {
                return (CodeLinter)linter.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalStateException("Failed to instantiate check " + linter.getName(), e);
            }
            catch (ClassCastException e) {
                throw new IllegalStateException(linter.getName() + " does not inherit from Check");
            }
        }).toList();
    }

    private boolean isRequiredCheck(ExecutableCheck check, Collection<? extends AbstractProblemType> problems) {
        return check.enabled() && problems.stream().anyMatch(p -> List.of(check.reportedProblems()).contains(p));
    }

    private static <T> List<T> castUnsafe(Iterable<?> list, Class<? extends T> clazz) {
        ArrayList<T> result = new ArrayList<T>();
        for (Object object : list) {
            result.add(clazz.cast(object));
        }
        return result;
    }
}

