/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core;

import de.firemage.autograder.core.file.SourceInfo;
import de.firemage.autograder.core.integrated.MethodHierarchy;
import de.firemage.autograder.core.integrated.ModelBuildException;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.UsesFinder;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import spoon.Launcher;
import spoon.compiler.Environment;
import spoon.compiler.ModelBuildingException;
import spoon.processing.AbstractProcessor;
import spoon.processing.Processor;
import spoon.reflect.CtModel;
import spoon.reflect.code.CtCatchVariable;
import spoon.reflect.code.CtTargetedExpression;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtNamedElement;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtType;
import spoon.reflect.factory.CodeFactory;
import spoon.reflect.factory.CoreFactory;
import spoon.reflect.factory.Factory;
import spoon.reflect.factory.FactoryImpl;
import spoon.reflect.reference.CtCatchVariableReference;
import spoon.reflect.reference.CtReference;
import spoon.reflect.visitor.CtScanner;
import spoon.reflect.visitor.CtVisitor;
import spoon.reflect.visitor.DefaultImportComparator;
import spoon.reflect.visitor.DefaultJavaPrettyPrinter;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.ForceImportProcessor;
import spoon.reflect.visitor.ImportCleaner;
import spoon.reflect.visitor.ImportConflictDetector;
import spoon.reflect.visitor.filter.NamedElementFilter;
import spoon.support.DefaultCoreFactory;
import spoon.support.StandardEnvironment;

public final class CodeModel
implements AutoCloseable {
    private final SourceInfo file;
    private final Path jar;
    private final ClassLoader userClassLoader;
    private final URLClassLoader classLoader;
    private Factory factory;
    private CtModel model;
    private CtPackage basePackage;
    private MethodHierarchy methodHierarchy;
    private Optional<CtMethod<Void>> mainMethod;

    private CodeModel(SourceInfo file, Path jar, ClassLoader classLoader) {
        this.file = file;
        this.jar = jar;
        if (classLoader != null) {
            this.userClassLoader = classLoader;
            this.classLoader = null;
        } else {
            try {
                this.classLoader = new URLClassLoader(new URL[]{jar.toUri().toURL()}, Thread.currentThread().getContextClassLoader());
                this.userClassLoader = null;
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static CodeModel buildFor(SourceInfo file, Path jar, ClassLoader classLoader) {
        return new CodeModel(file, jar, classLoader);
    }

    public void ensureModelBuild() {
        this.buildModelMaybe();
    }

    public Factory getFactory() {
        this.buildModelMaybe();
        return this.factory;
    }

    public CtModel getModel() {
        this.buildModelMaybe();
        return this.model;
    }

    public <E extends CtElement> void processWith(Processor<E> processor) {
        this.buildModelMaybe();
        this.model.processWith(processor);
    }

    public CtMethod<Void> findMain() {
        this.buildModelMaybe();
        if (this.mainMethod == null) {
            this.mainMethod = this.getModel().getElements((Filter)new NamedElementFilter(CtMethod.class, "main")).stream().filter(SpoonUtil::isMainMethod).findFirst().map(ctMethod -> ctMethod);
        }
        return this.mainMethod.orElse(null);
    }

    public boolean hasMainMethod() {
        return this.findMain() != null;
    }

    public CtPackage getBasePackage() {
        this.buildModelMaybe();
        return this.basePackage;
    }

    public void visualize() {
        this.buildModelMaybe();
        this.model.getRootPackage().accept((CtVisitor)new ModelVisualizer());
    }

    @Override
    public void close() throws IOException {
        if (this.classLoader != null) {
            this.classLoader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildModelMaybe() {
        if (this.model != null) {
            return;
        }
        CodeModel codeModel = this;
        synchronized (codeModel) {
            CtModel model;
            if (this.model != null) {
                return;
            }
            FactoryImpl baseFactory = new FactoryImpl((CoreFactory)new DefaultCoreFactory(), (Environment)new StandardEnvironment()){
                private transient CodeFactory code;

                public CodeFactory Code() {
                    if (this.code == null) {
                        this.code = new CodeFactory((Factory)this){

                            public <T> CtCatchVariableReference<T> createCatchVariableReference(CtCatchVariable<T> catchVariable) {
                                CtCatchVariableReference ref = this.factory.Core().createCatchVariableReference();
                                ref.setType(catchVariable.getType() == null ? null : catchVariable.getType().clone());
                                ref.setSimpleName(catchVariable.getSimpleName());
                                ref.setParent(catchVariable);
                                return ref;
                            }
                        };
                    }
                    return this.code;
                }
            };
            Launcher launcher = new Launcher((Factory)baseFactory);
            launcher.addInputResource(this.file.getSpoonResource());
            launcher.getEnvironment().setShouldCompile(false);
            launcher.getEnvironment().setSourceClasspath(new String[]{this.jar.toAbsolutePath().toString()});
            launcher.getEnvironment().setNoClasspath(false);
            launcher.getEnvironment().setCommentEnabled(true);
            launcher.getEnvironment().setComplianceLevel(this.file.getVersion().getVersionNumber());
            launcher.getEnvironment().setEncodingProvider((spoonFile, fileBytes) -> {
                try {
                    return this.file.getCompilationUnit(Path.of(spoonFile.getPath(), new String[0])).charset();
                }
                catch (Exception e) {
                    return StandardCharsets.UTF_8;
                }
            });
            Environment environment = launcher.getEnvironment();
            environment.setPrettyPrinterCreator(() -> new DefaultJavaPrettyPrinter(environment){
                {
                    List<ImportCleaner> preprocessors = List.of(new ForceImportProcessor(), new ImportCleaner().setCanAddImports(false), new ImportConflictDetector(), new ImportCleaner().setImportComparator((Comparator)new DefaultImportComparator()));
                    this.setIgnoreImplicit(false);
                    this.setPreprocessors(preprocessors);
                    this.setMinimizeRoundBrackets(true);
                }
            });
            if (this.userClassLoader != null) {
                launcher.getEnvironment().setInputClassLoader(this.userClassLoader);
            } else {
                launcher.getEnvironment().setInputClassLoader((ClassLoader)this.classLoader);
            }
            try {
                model = launcher.buildModel();
            }
            catch (ModelBuildingException e) {
                throw new RuntimeException((Throwable)((Object)new ModelBuildException("Failed to parse the code", e)));
            }
            this.factory = launcher.getFactory();
            model.processWith((Processor)new AbstractProcessor<CtType<?>>(){

                public void process(CtType<?> type) {
                    if (type.getPackage() == null || type.getPackage().getQualifiedName().startsWith("java.")) {
                        return;
                    }
                    if (CodeModel.this.basePackage == null) {
                        CodeModel.this.basePackage = type.getPackage();
                        return;
                    }
                    String typePackage = type.getPackage().getQualifiedName();
                    while (!typePackage.startsWith(CodeModel.this.basePackage.getQualifiedName())) {
                        CodeModel.this.basePackage = CodeModel.this.basePackage.getDeclaringPackage();
                    }
                }
            });
            MethodHierarchy.buildFor(model);
            UsesFinder.buildFor(model);
            this.model = model;
        }
    }

    private static class ModelVisualizer
    extends CtScanner {
        private int level = 0;

        private ModelVisualizer() {
        }

        public void scan(CtElement element) {
            if (!(element instanceof CtReference)) {
                super.scan(element);
            }
        }

        protected void enter(CtElement e) {
            Object label = e.getClass().getSimpleName().replaceAll("Impl$", "");
            if (e instanceof CtNamedElement) {
                CtNamedElement namedElement = (CtNamedElement)e;
                label = (String)label + ": " + namedElement.getSimpleName();
            } else if (e instanceof CtTargetedExpression) {
                CtTargetedExpression targetedExpression = (CtTargetedExpression)e;
                label = (String)label + " -> " + targetedExpression.getTarget();
            }
            System.out.println("  ".repeat(this.level) + (String)label + " (" + e.getRoleInParent() + ")");
            ++this.level;
        }

        protected void exit(CtElement e) {
            super.exit(e);
            --this.level;
        }
    }
}

