/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.parallel;

import de.firemage.autograder.core.Problem;
import de.firemage.autograder.core.parallel.AnalysisResult;
import de.firemage.autograder.core.parallel.AnalysisTask;
import de.firemage.autograder.core.parallel.AnalysisThread;
import de.firemage.autograder.core.parallel.ProblemReporter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;

public class AnalysisScheduler {
    private final ClassLoader classLoader;
    private final List<AnalysisThread> analysisThreads;
    private final Queue<AnalysisTask> waitingTasks;
    private volatile boolean completionAllowed;
    private final AtomicInteger waitingAndRunningTaskCount;

    public AnalysisScheduler(int threads, ClassLoader classLoader) {
        int actualThreads;
        this.classLoader = classLoader;
        this.waitingTasks = new ArrayDeque<AnalysisTask>();
        this.completionAllowed = false;
        this.waitingAndRunningTaskCount = new AtomicInteger(0);
        this.analysisThreads = new ArrayList<AnalysisThread>();
        int n = actualThreads = threads > 0 ? threads : Math.max(Runtime.getRuntime().availableProcessors() - 2, 1);
        if (actualThreads == 1) {
            return;
        }
        for (int i = 0; i < actualThreads; ++i) {
            AnalysisThread thread = new AnalysisThread(this, i);
            thread.start();
            this.analysisThreads.add(thread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submitTask(AnalysisTask task) {
        Queue<AnalysisTask> queue = this.waitingTasks;
        synchronized (queue) {
            this.waitingTasks.add(task);
            this.waitingAndRunningTaskCount.incrementAndGet();
            this.waitingTasks.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Optional<AnalysisTask> getTask() throws InterruptedException {
        Queue<AnalysisTask> queue = this.waitingTasks;
        synchronized (queue) {
            while (this.waitingTasks.isEmpty()) {
                this.waitingTasks.wait(300L);
                if (!this.completionAllowed || this.waitingAndRunningTaskCount.get() != 0) continue;
                return Optional.empty();
            }
            return Optional.of(this.waitingTasks.poll());
        }
    }

    protected boolean completeTask() {
        return this.waitingAndRunningTaskCount.decrementAndGet() == 0 && this.completionAllowed;
    }

    protected ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public AnalysisResult collectProblems() {
        if (this.analysisThreads.isEmpty()) {
            return this.executeChecksSingleThreaded();
        }
        return this.collectProblemsFromThreads();
    }

    private AnalysisResult collectProblemsFromThreads() {
        this.completionAllowed = true;
        ArrayList<Problem> allProblems = new ArrayList<Problem>();
        for (AnalysisThread thread : this.analysisThreads) {
            try {
                AnalysisResult result = thread.join();
                if (result.failed()) {
                    return result;
                }
                allProblems.addAll(result.problems());
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
        }
        return AnalysisResult.forSuccess(allProblems);
    }

    private AnalysisResult executeChecksSingleThreaded() {
        final ArrayList<Problem> allProblems = new ArrayList<Problem>();
        ProblemReporter reporter = new ProblemReporter(){

            @Override
            public void reportProblem(Problem problem) {
                allProblems.add(problem);
            }

            @Override
            public void reportProblems(Collection<Problem> problems) {
                allProblems.addAll(problems);
            }
        };
        while (!this.waitingTasks.isEmpty()) {
            try {
                AnalysisTask task = this.waitingTasks.poll();
                task.run(this, reporter);
            }
            catch (Exception e) {
                return AnalysisResult.forFailure(e);
            }
        }
        return AnalysisResult.forSuccess(allProblems);
    }
}

