/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.integrated.evaluator.fold;

import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtUnaryOperator;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.declaration.CtElement;

public interface Fold {
    default public CtElement enter(CtElement ctElement) {
        return ctElement;
    }

    default public CtElement exit(CtElement ctElement) {
        return this.fold(ctElement);
    }

    default public CtElement fold(CtElement ctElement) {
        if (ctElement instanceof CtExpression) {
            CtExpression ctExpression = (CtExpression)ctElement;
            return this.foldCtExpression(ctExpression);
        }
        return ctElement;
    }

    default public <T> CtExpression<T> foldCtExpression(CtExpression<T> ctExpression) {
        if (ctExpression instanceof CtLiteral) {
            CtLiteral ctLiteral = (CtLiteral)ctExpression;
            return this.foldCtLiteral(ctLiteral);
        }
        if (ctExpression instanceof CtBinaryOperator) {
            CtBinaryOperator ctBinaryOperator = (CtBinaryOperator)ctExpression;
            return this.foldCtBinaryOperator(ctBinaryOperator);
        }
        if (ctExpression instanceof CtUnaryOperator) {
            CtUnaryOperator ctUnaryOperator = (CtUnaryOperator)ctExpression;
            return this.foldCtUnaryOperator(ctUnaryOperator);
        }
        if (ctExpression instanceof CtVariableRead) {
            CtVariableRead ctVariableRead = (CtVariableRead)ctExpression;
            return this.foldCtVariableRead(ctVariableRead);
        }
        return ctExpression;
    }

    default public <T> CtExpression<T> foldCtLiteral(CtLiteral<T> ctLiteral) {
        return ctLiteral;
    }

    default public <T> CtExpression<T> foldCtBinaryOperator(CtBinaryOperator<T> ctBinaryOperator) {
        return ctBinaryOperator;
    }

    default public <T> CtExpression<T> foldCtUnaryOperator(CtUnaryOperator<T> ctUnaryOperator) {
        return ctUnaryOperator;
    }

    default public <T> CtExpression<T> foldCtVariableRead(CtVariableRead<T> ctVariableRead) {
        return ctVariableRead;
    }
}

