/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.integrated.evaluator.fold;

import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.evaluator.OperatorHelper;
import de.firemage.autograder.core.integrated.evaluator.fold.Fold;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtUnaryOperator;
import spoon.reflect.reference.CtTypeReference;

public final class ApplyOperatorPromotion
implements Fold {
    public static final OperatorPredicate<? super CtExpression<?>> APPLY_ON_LITERAL_OPERAND = (operator, ctExpression) -> ctExpression instanceof CtLiteral;
    private final OperatorPredicate<? super CtBinaryOperator<?>> shouldApplyOnBinaryOperator;
    private final OperatorPredicate<? super CtUnaryOperator<?>> shouldApplyOnUnaryOperator;

    private ApplyOperatorPromotion(OperatorPredicate<? super CtBinaryOperator<?>> shouldApplyOnBinaryOperator, OperatorPredicate<? super CtUnaryOperator<?>> shouldApplyOnUnaryOperator) {
        this.shouldApplyOnBinaryOperator = shouldApplyOnBinaryOperator;
        this.shouldApplyOnUnaryOperator = shouldApplyOnUnaryOperator;
    }

    public static Fold create() {
        return ApplyOperatorPromotion.create(APPLY_ON_LITERAL_OPERAND, APPLY_ON_LITERAL_OPERAND);
    }

    public static Fold create(OperatorPredicate<? super CtBinaryOperator<?>> shouldApplyOnBinaryOperator, OperatorPredicate<? super CtUnaryOperator<?>> shouldApplyOnUnaryOperator) {
        return new ApplyOperatorPromotion(shouldApplyOnBinaryOperator, shouldApplyOnUnaryOperator);
    }

    @Override
    public <T> CtExpression<T> foldCtBinaryOperator(CtBinaryOperator<T> ctBinaryOperator) {
        if (ctBinaryOperator.getKind() == BinaryOperatorKind.INSTANCEOF) {
            return ctBinaryOperator;
        }
        CtTypeReference promotedType = OperatorHelper.getPromotedType(ctBinaryOperator.getKind(), ctBinaryOperator.getLeftHandOperand(), ctBinaryOperator.getRightHandOperand()).orElse(null);
        if (promotedType == null) {
            return ctBinaryOperator;
        }
        if (this.shouldApplyOnBinaryOperator.shouldApplyOn(ctBinaryOperator, ctBinaryOperator.getLeftHandOperand())) {
            ctBinaryOperator.setLeftHandOperand(SpoonUtil.castExpression(promotedType, ctBinaryOperator.getLeftHandOperand()));
        }
        if (this.shouldApplyOnBinaryOperator.shouldApplyOn(ctBinaryOperator, ctBinaryOperator.getRightHandOperand())) {
            ctBinaryOperator.setRightHandOperand(SpoonUtil.castExpression(promotedType, ctBinaryOperator.getRightHandOperand()));
        }
        return ctBinaryOperator;
    }

    @Override
    public <T> CtExpression<T> foldCtUnaryOperator(CtUnaryOperator<T> ctUnaryOperator) {
        CtTypeReference promotedType = OperatorHelper.getPromotedType(ctUnaryOperator.getKind(), ctUnaryOperator.getOperand()).orElse(null);
        if (promotedType == null) {
            return ctUnaryOperator;
        }
        if (this.shouldApplyOnUnaryOperator.shouldApplyOn(ctUnaryOperator, ctUnaryOperator.getOperand())) {
            ctUnaryOperator.setOperand(SpoonUtil.castExpression(promotedType, ctUnaryOperator.getOperand()));
        }
        return ctUnaryOperator;
    }

    @FunctionalInterface
    public static interface OperatorPredicate<T extends CtExpression<?>> {
        public boolean shouldApplyOn(T var1, CtExpression<?> var2);
    }
}

