/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.integrated.evaluator;

import de.firemage.autograder.core.integrated.SpoonUtil;
import java.util.Optional;
import java.util.Set;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.code.UnaryOperatorKind;
import spoon.reflect.factory.TypeFactory;
import spoon.reflect.reference.CtTypeReference;

public final class OperatorHelper {
    private static final Set<Class<?>> WHOLE_NUMBERS = Set.of(Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE);
    private static final Set<Class<?>> NUMBERS_PROMOTED_TO_INT = Set.of(Byte.TYPE, Short.TYPE, Character.TYPE);

    private OperatorHelper() {
    }

    public static String getOperatorText(UnaryOperatorKind operatorKind) {
        return switch (operatorKind) {
            default -> throw new IncompatibleClassChangeError();
            case UnaryOperatorKind.POS -> "+";
            case UnaryOperatorKind.NEG -> "-";
            case UnaryOperatorKind.NOT -> "!";
            case UnaryOperatorKind.COMPL -> "~";
            case UnaryOperatorKind.PREINC -> "++";
            case UnaryOperatorKind.PREDEC -> "--";
            case UnaryOperatorKind.POSTINC -> "++";
            case UnaryOperatorKind.POSTDEC -> "--";
        };
    }

    public static String getOperatorText(BinaryOperatorKind operatorKind) {
        return switch (operatorKind) {
            default -> throw new IncompatibleClassChangeError();
            case BinaryOperatorKind.OR -> "||";
            case BinaryOperatorKind.AND -> "&&";
            case BinaryOperatorKind.BITOR -> "|";
            case BinaryOperatorKind.BITXOR -> "^";
            case BinaryOperatorKind.BITAND -> "&";
            case BinaryOperatorKind.EQ -> "==";
            case BinaryOperatorKind.NE -> "!=";
            case BinaryOperatorKind.LT -> "<";
            case BinaryOperatorKind.GT -> ">";
            case BinaryOperatorKind.LE -> "<=";
            case BinaryOperatorKind.GE -> ">=";
            case BinaryOperatorKind.SL -> "<<";
            case BinaryOperatorKind.SR -> ">>";
            case BinaryOperatorKind.USR -> ">>>";
            case BinaryOperatorKind.PLUS -> "+";
            case BinaryOperatorKind.MINUS -> "-";
            case BinaryOperatorKind.MUL -> "*";
            case BinaryOperatorKind.DIV -> "/";
            case BinaryOperatorKind.MOD -> "%";
            case BinaryOperatorKind.INSTANCEOF -> "instanceof";
        };
    }

    private static boolean isIntegralType(CtTypeReference<?> ctTypeReference) {
        return ctTypeReference.isPrimitive() && (WHOLE_NUMBERS.contains(ctTypeReference.getActualClass()) || ctTypeReference.getActualClass().equals(Character.TYPE));
    }

    private static boolean isNumericType(CtTypeReference<?> ctTypeReference) {
        return ctTypeReference.isPrimitive() && !ctTypeReference.getActualClass().equals(Boolean.TYPE);
    }

    private static Optional<CtTypeReference<?>> unaryNumericPromotion(CtTypeReference<?> operandType) {
        if (!OperatorHelper.isNumericType(operandType = operandType.unbox())) {
            return Optional.empty();
        }
        if (NUMBERS_PROMOTED_TO_INT.contains(operandType.getActualClass())) {
            return Optional.of(operandType.getFactory().Type().integerPrimitiveType());
        }
        return Optional.of(operandType);
    }

    private static Optional<CtTypeReference<?>> binaryNumericPromotion(CtTypeReference<?> leftType, CtTypeReference<?> rightType) {
        TypeFactory typeFactory = leftType.getFactory().Type();
        leftType = leftType.unbox();
        rightType = rightType.unbox();
        if (!OperatorHelper.isNumericType(leftType) || !OperatorHelper.isNumericType(rightType)) {
            return Optional.empty();
        }
        CtTypeReference doubleType = typeFactory.doublePrimitiveType();
        if (leftType.equals(doubleType) || rightType.equals(doubleType)) {
            return Optional.of(doubleType);
        }
        CtTypeReference floatType = typeFactory.floatPrimitiveType();
        if (leftType.equals(floatType) || rightType.equals(floatType)) {
            return Optional.of(floatType);
        }
        CtTypeReference longType = typeFactory.longPrimitiveType();
        if (leftType.equals(longType) || rightType.equals(longType)) {
            return Optional.of(longType);
        }
        return Optional.of(typeFactory.integerPrimitiveType());
    }

    public static Optional<CtTypeReference<?>> getPromotedType(BinaryOperatorKind operator, CtExpression<?> left, CtExpression<?> right) {
        TypeFactory typeFactory = left.getFactory().Type();
        CtTypeReference<?> leftType = SpoonUtil.getExpressionType(left);
        CtTypeReference<?> rightType = SpoonUtil.getExpressionType(right);
        switch (operator) {
            case OR: 
            case AND: {
                CtTypeReference booleanType = typeFactory.booleanPrimitiveType();
                if (!leftType.equals((Object)booleanType) || !rightType.equals((Object)booleanType)) {
                    return Optional.empty();
                }
                return Optional.of(booleanType);
            }
            case SL: 
            case SR: 
            case USR: {
                CtTypeReference promotedLeft = OperatorHelper.unaryNumericPromotion(leftType).orElse(null);
                CtTypeReference promotedRight = OperatorHelper.unaryNumericPromotion(rightType).orElse(null);
                if (promotedLeft == null || promotedRight == null) {
                    return Optional.empty();
                }
                if (!OperatorHelper.isIntegralType(promotedLeft) || !OperatorHelper.isIntegralType(promotedRight)) {
                    return Optional.empty();
                }
                return Optional.of(promotedLeft);
            }
            case INSTANCEOF: {
                throw new UnsupportedOperationException("instanceof is not yet implemented");
            }
            case EQ: 
            case NE: {
                CtTypeReference unboxedLeftType = leftType.unbox();
                CtTypeReference unboxedRightType = rightType.unbox();
                CtTypeReference booleanType = typeFactory.booleanPrimitiveType();
                return OperatorHelper.binaryNumericPromotion(leftType, rightType).or(() -> {
                    if (unboxedLeftType.equals(unboxedRightType) && unboxedLeftType.equals(booleanType)) {
                        return Optional.of(booleanType);
                    }
                    if (!unboxedLeftType.isPrimitive() && !unboxedRightType.isPrimitive()) {
                        CtTypeReference nullType = typeFactory.nullType();
                        if (unboxedLeftType.equals(nullType)) {
                            return Optional.of(unboxedRightType);
                        }
                        if (unboxedRightType.equals(nullType)) {
                            return Optional.of(unboxedLeftType);
                        }
                        if (unboxedLeftType.isSubtypeOf(unboxedRightType)) {
                            return Optional.of(unboxedRightType);
                        }
                        if (unboxedRightType.isSubtypeOf(unboxedLeftType)) {
                            return Optional.of(unboxedRightType);
                        }
                        return Optional.empty();
                    }
                    return Optional.empty();
                });
            }
            case LT: 
            case GT: 
            case LE: 
            case GE: 
            case MINUS: 
            case MUL: 
            case DIV: 
            case MOD: {
                return OperatorHelper.binaryNumericPromotion(leftType, rightType);
            }
            case PLUS: {
                return OperatorHelper.binaryNumericPromotion(leftType, rightType).or(() -> {
                    CtTypeReference stringType = typeFactory.stringType();
                    if (leftType.equals(stringType) || rightType.equals(stringType)) {
                        return Optional.of(stringType);
                    }
                    return Optional.empty();
                });
            }
            case BITOR: 
            case BITXOR: 
            case BITAND: {
                CtTypeReference unboxedLeftType = leftType.unbox();
                CtTypeReference unboxedRightType = rightType.unbox();
                Set<CtTypeReference> floatingPointNumbers = Set.of(typeFactory.floatPrimitiveType(), typeFactory.doublePrimitiveType());
                if (floatingPointNumbers.contains(unboxedLeftType) || floatingPointNumbers.contains(unboxedRightType)) {
                    return Optional.empty();
                }
                if (unboxedLeftType.equals(unboxedRightType) && unboxedLeftType.equals(typeFactory.booleanPrimitiveType())) {
                    return Optional.of(unboxedLeftType);
                }
                return OperatorHelper.binaryNumericPromotion(leftType, rightType);
            }
        }
        throw new UnsupportedOperationException("Unknown operator: " + operator);
    }

    public static Optional<CtTypeReference<?>> getPromotedType(UnaryOperatorKind operator, CtExpression<?> operand) {
        TypeFactory typeFactory = operand.getFactory().Type();
        CtTypeReference<?> operandType = SpoonUtil.getExpressionType(operand);
        return switch (operator) {
            default -> throw new IncompatibleClassChangeError();
            case UnaryOperatorKind.COMPL -> {
                if (OperatorHelper.isIntegralType(operandType.unbox())) {
                    yield OperatorHelper.unaryNumericPromotion(operandType);
                }
                yield Optional.empty();
            }
            case UnaryOperatorKind.POS, UnaryOperatorKind.NEG -> OperatorHelper.unaryNumericPromotion(operandType);
            case UnaryOperatorKind.NOT -> {
                if (operandType.unbox().equals(typeFactory.booleanPrimitiveType())) {
                    yield Optional.of(typeFactory.booleanPrimitiveType());
                }
                yield Optional.empty();
            }
            case UnaryOperatorKind.PREINC, UnaryOperatorKind.PREDEC, UnaryOperatorKind.POSTINC, UnaryOperatorKind.POSTDEC -> !(operand instanceof CtVariableRead) || !OperatorHelper.isNumericType(operandType.unbox()) ? Optional.empty() : Optional.of(operandType);
        };
    }
}

