/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.integrated;

import de.firemage.autograder.core.CodeModel;
import de.firemage.autograder.core.compiler.CompilationResult;
import de.firemage.autograder.core.integrated.SpoonUtil;
import java.util.concurrent.atomic.AtomicBoolean;
import spoon.processing.Processor;
import spoon.reflect.CtModel;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtImport;
import spoon.reflect.factory.Factory;
import spoon.reflect.reference.CtPackageReference;
import spoon.reflect.reference.CtReference;
import spoon.reflect.reference.CtTypeReference;

public class StaticAnalysis {
    private final CodeModel model;
    private final CompilationResult compilationResult;

    public StaticAnalysis(CodeModel model, CompilationResult compilationResult) {
        this.model = model;
        this.compilationResult = compilationResult;
    }

    public Factory getFactory() {
        return this.model.getFactory();
    }

    public CtModel getModel() {
        return this.model.getModel();
    }

    public CodeModel getCodeModel() {
        return this.model;
    }

    public CompilationResult getCompilationResult() {
        return this.compilationResult;
    }

    public <E extends CtElement> void processWith(Processor<E> processor) {
        this.model.processWith(processor);
    }

    private static boolean isJavaUtilImport(CtImport ctImport) {
        CtPackageReference ctPackageReference = null;
        CtReference ctReference = ctImport.getReference();
        if (ctReference instanceof CtTypeReference) {
            CtTypeReference ctTypeReference = (CtTypeReference)ctReference;
            ctPackageReference = ctTypeReference.getTypeDeclaration().getPackage().getReference();
        } else {
            ctReference = ctImport.getReference();
            if (ctReference instanceof CtPackageReference) {
                CtPackageReference packageReference;
                ctPackageReference = packageReference = (CtPackageReference)ctReference;
            }
        }
        return ctPackageReference != null && ctPackageReference.getQualifiedName().equals("java.util");
    }

    public boolean hasJavaUtilImport() {
        AtomicBoolean hasImport = new AtomicBoolean(false);
        SpoonUtil.visitCtCompilationUnit(this.getModel(), ctCompilationUnit -> {
            if (hasImport.get()) {
                return;
            }
            for (CtImport ctImport : ctCompilationUnit.getImports()) {
                if (!StaticAnalysis.isJavaUtilImport(ctImport)) continue;
                hasImport.set(true);
                break;
            }
        });
        return hasImport.get();
    }
}

