/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.integrated;

import java.util.Set;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtTypeAccess;
import spoon.reflect.reference.CtTypeReference;

public final class SpoonStreamUtil {
    private static final Set<String> STREAM_CLASSES = Set.of("java.util.stream.Stream", "java.util.stream.IntStream", "java.util.stream.LongStream", "java.util.stream.DoubleStream");

    private SpoonStreamUtil() {
    }

    public static boolean isStream(CtTypeReference<?> type) {
        return STREAM_CLASSES.contains(type.getQualifiedName());
    }

    public static boolean isStreamOperation(CtInvocation<?> invocation) {
        return SpoonStreamUtil.isStream(invocation.getType());
    }

    public static boolean isCollectOperation(CtInvocation<?> invocation, String name) {
        CtTypeAccess type;
        CtInvocation collect;
        Object object;
        return SpoonStreamUtil.isStreamOperation(invocation) && invocation.getExecutable().getSimpleName().equals("collect") && !invocation.getArguments().isEmpty() && (object = invocation.getArguments().get(0)) instanceof CtInvocation && (collect = (CtInvocation)object).getExecutable().getSimpleName().equals(name) && (object = collect.getTarget()) instanceof CtTypeAccess && (type = (CtTypeAccess)object).getAccessedType().getQualifiedName().equals("java.util.streamCollectors");
    }
}

