/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.file;

import de.firemage.autograder.core.compiler.JavaVersion;
import de.firemage.autograder.core.file.CompilationUnit;
import de.firemage.autograder.core.file.SourcePath;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Path;
import java.util.List;
import spoon.compiler.SpoonResource;

public interface SourceInfo
extends Serializable {
    public List<CompilationUnit> compilationUnits() throws IOException;

    public SourceInfo copyTo(Path var1) throws IOException;

    public SpoonResource getSpoonResource();

    default public String getName() {
        return this.path().getFileName().toString();
    }

    default public CompilationUnit getCompilationUnit(SourcePath path) {
        List<CompilationUnit> compilationUnits;
        try {
            compilationUnits = this.compilationUnits();
        }
        catch (IOException exception) {
            throw new IllegalStateException("Could not read compilation units", exception);
        }
        for (CompilationUnit compilationUnit : compilationUnits) {
            if (!path.equals(compilationUnit.path())) continue;
            return compilationUnit;
        }
        throw new IllegalStateException("Could not find compilation unit for path '%s'".formatted(path));
    }

    default public CompilationUnit getCompilationUnit(Path path) {
        Path relative;
        Path root = this.path();
        try {
            relative = root.relativize(path);
        }
        catch (IllegalArgumentException exception) {
            relative = path;
        }
        return this.getCompilationUnit(SourcePath.of(relative));
    }

    default public CompilationUnit getCompilationUnit(URI uri) {
        Path path = uri.getScheme().equals("string") ? Path.of(uri.getPath().substring(1), new String[0]) : Path.of(uri);
        return this.getCompilationUnit(path);
    }

    public Path path();

    public JavaVersion getVersion();
}

