/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.errorprone;

import de.firemage.autograder.core.errorprone.SerializableSupplier;
import de.firemage.autograder.core.errorprone.TempLocation;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Optional;

public record VMLauncher(List<String> jvmArgs, TempLocation tempLocation, Optional<String> mainClassName) {
    public static VMLauncher fromDefault(TempLocation tmpLocation) throws IOException {
        String[] args;
        Optional<String> mainClassName = Optional.empty();
        String potentialName = System.getProperty("sun.java.command");
        if (potentialName != null && (args = potentialName.split(" ")).length > 0) {
            mainClassName = Optional.of(args[0]);
        }
        return new VMLauncher(Arrays.asList("--add-exports=jdk.compiler/com.sun.tools.javac.api=ALL-UNNAMED", "--add-exports=jdk.compiler/com.sun.tools.javac.file=ALL-UNNAMED", "--add-exports=jdk.compiler/com.sun.tools.javac.code=ALL-UNNAMED", "--add-exports=jdk.compiler/com.sun.tools.javac.comp=ALL-UNNAMED", "--add-exports=jdk.compiler/com.sun.tools.javac.main=ALL-UNNAMED", "--add-exports=jdk.compiler/com.sun.tools.javac.model=ALL-UNNAMED", "--add-exports=jdk.compiler/com.sun.tools.javac.parser=ALL-UNNAMED", "--add-exports=jdk.compiler/com.sun.tools.javac.processing=ALL-UNNAMED", "--add-exports=jdk.compiler/com.sun.tools.javac.tree=ALL-UNNAMED", "--add-exports=jdk.compiler/com.sun.tools.javac.util=ALL-UNNAMED", "--add-exports=jdk.compiler/com.sun.source.tree=ALL-UNNAMED"), tmpLocation.createTempDirectory("vm"), mainClassName);
    }

    private static String serialize(Serializable serializable) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);){
            objectOutputStream.writeObject(serializable);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to serialize object", e);
        }
        return Base64.getEncoder().encodeToString(byteArrayOutputStream.toByteArray());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T extends Serializable> T deserialize(String string) {
        byte[] data = Base64.getDecoder().decode(string);
        try (ObjectInputStream objectInput = new ObjectInputStream(new ByteArrayInputStream(data));){
            Serializable serializable = (Serializable)objectInput.readObject();
            return (T)serializable;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new IllegalArgumentException("Failed to deserialize object", e);
        }
    }

    public <T extends Serializable> VMHandle<T> runInNewJVM(SerializableSupplier<T> supplier) throws IOException {
        ProcessHandle.Info currentProcessInfo = ProcessHandle.current().info();
        ArrayList<String> newProcessCommandLine = new ArrayList<String>();
        newProcessCommandLine.add(currentProcessInfo.command().orElseThrow());
        newProcessCommandLine.add("-classpath");
        newProcessCommandLine.add(ManagementFactory.getRuntimeMXBean().getClassPath());
        Path resultFileLocation = this.tempLocation.createTempFile("result.txt");
        newProcessCommandLine.addAll(this.jvmArgs);
        newProcessCommandLine.add(TargetMain.class.getName());
        newProcessCommandLine.add(VMLauncher.serialize(supplier));
        newProcessCommandLine.add(resultFileLocation.toString());
        return new VMHandle(new ProcessBuilder(newProcessCommandLine), resultFileLocation);
    }

    private static final class TargetMain {
        private TargetMain() {
        }

        private static void run(String[] args) {
            SerializableSupplier supplier = (SerializableSupplier)VMLauncher.deserialize(args[0]);
            try {
                Object value = supplier.get();
                Files.writeString(Path.of(args[1], new String[0]), (CharSequence)VMLauncher.serialize(value), new OpenOption[0]);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to serialize supplier result", e);
            }
        }

        public static void main(String[] args) {
            try {
                TargetMain.run(args);
                System.exit(0);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.exit(1);
            }
        }
    }

    public static final class VMHandle<T extends Serializable> {
        private final Process process;
        private final Path resultFileLocation;
        private T value;

        private VMHandle(ProcessBuilder processBuilder, Path resultFileLocation) throws IOException {
            this.process = processBuilder.redirectOutput(ProcessBuilder.Redirect.INHERIT).redirectError(ProcessBuilder.Redirect.INHERIT).start();
            this.value = null;
            this.resultFileLocation = resultFileLocation;
        }

        private T getValue() throws IOException {
            if (this.value == null) {
                this.value = VMLauncher.deserialize(Files.readString(this.resultFileLocation));
            }
            return this.value;
        }

        public T join() throws InterruptedException, IOException {
            int exitCode = this.process.waitFor();
            if (exitCode != 0) {
                throw new IllegalStateException("Process exited with non-zero exit code: " + exitCode);
            }
            return this.getValue();
        }
    }
}

