/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.errorprone;

import de.firemage.autograder.core.Problem;
import de.firemage.autograder.core.check.Check;
import de.firemage.autograder.core.errorprone.ErrorProneCheck;
import de.firemage.autograder.core.errorprone.ErrorProneCompiler;
import de.firemage.autograder.core.errorprone.ErrorProneDiagnostic;
import de.firemage.autograder.core.errorprone.ErrorProneLint;
import de.firemage.autograder.core.errorprone.Message;
import de.firemage.autograder.core.errorprone.TempLocation;
import de.firemage.autograder.core.file.SourceInfo;
import de.firemage.autograder.core.file.UploadedFile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class ErrorProneLinter {
    public List<Problem> lint(UploadedFile file, TempLocation tempLocation, Iterable<? extends ErrorProneCheck> checks) throws IOException {
        HashMap<ErrorProneLint, Function<ErrorProneDiagnostic, Message>> lintsForChecks = new HashMap<ErrorProneLint, Function<ErrorProneDiagnostic, Message>>();
        HashMap<ErrorProneLint, ErrorProneCheck> checksForLints = new HashMap<ErrorProneLint, ErrorProneCheck>();
        for (ErrorProneCheck errorProneCheck : checks) {
            for (Map.Entry<ErrorProneLint, Function<ErrorProneDiagnostic, Message>> entry : errorProneCheck.subscribedLints().entrySet()) {
                ErrorProneLint lint = entry.getKey();
                if (lintsForChecks.containsKey(lint)) {
                    throw new IllegalStateException("Lint " + lint + " is used by multiple checks");
                }
                checksForLints.put(lint, errorProneCheck);
                lintsForChecks.put(lint, entry.getValue());
            }
        }
        ArrayList<ErrorProneLint> lints = new ArrayList<ErrorProneLint>(lintsForChecks.keySet());
        SourceInfo sourceInfo = file.getSource();
        ErrorProneCompiler compiler = new ErrorProneCompiler(sourceInfo.getVersion(), tempLocation, lints);
        List<ErrorProneDiagnostic> diagnostics = compiler.compile(sourceInfo);
        HashMap diagnosticMapping = new HashMap();
        for (ErrorProneDiagnostic diagnostic : diagnostics) {
            ErrorProneLint lint = diagnostic.lint();
            diagnosticMapping.computeIfAbsent(lint, key -> new ArrayList());
            ((List)diagnosticMapping.get(lint)).add(diagnostic);
        }
        ArrayList<Problem> result = new ArrayList<Problem>();
        for (Map.Entry entry : lintsForChecks.entrySet()) {
            ErrorProneLint lint = (ErrorProneLint)entry.getKey();
            Function getMessage = (Function)entry.getValue();
            List diagnosticList = diagnosticMapping.getOrDefault(lint, List.of());
            for (ErrorProneDiagnostic diagnostic : diagnosticList) {
                Message message = (Message)getMessage.apply(diagnostic);
                result.add(message.toProblem((Check)checksForLints.get(lint), diagnostic.position()));
            }
        }
        return result;
    }
}

