/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.errorprone;

import com.google.errorprone.BugPattern;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public final class ErrorProneLint
implements Serializable {
    private static final Collection<String> VALID_LINTS;
    private final String lint;

    private ErrorProneLint(String lint) {
        this.lint = lint;
    }

    public static ErrorProneLint fromString(String string) {
        if (VALID_LINTS.contains(string)) {
            return new ErrorProneLint(string);
        }
        throw new IllegalArgumentException("Unknown lint '%s'".formatted(string));
    }

    public String toString() {
        return this.lint;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ErrorProneLint)) {
            return false;
        }
        ErrorProneLint that = (ErrorProneLint)other;
        return this.lint.equals(that.lint);
    }

    public int hashCode() {
        return this.lint.hashCode();
    }

    static {
        Reflections reflections = new Reflections("com.google.errorprone.bugpatterns", new Scanner[0]);
        VALID_LINTS = reflections.getTypesAnnotatedWith(BugPattern.class).stream().flatMap(ctClass -> {
            BugPattern annotation = ctClass.getAnnotation(BugPattern.class);
            ArrayList<String> names = new ArrayList<String>(Arrays.asList(annotation.altNames()));
            if (annotation.name().isEmpty()) {
                names.add(ctClass.getSimpleName());
            } else {
                names.add(annotation.name());
            }
            return names.stream();
        }).collect(Collectors.toUnmodifiableSet());
    }
}

