/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.errorprone;

import de.firemage.autograder.core.compiler.JavaVersion;
import de.firemage.autograder.core.errorprone.ErrorProneDiagnostic;
import de.firemage.autograder.core.errorprone.ErrorProneLint;
import de.firemage.autograder.core.errorprone.TempLocation;
import de.firemage.autograder.core.errorprone.VMLauncher;
import de.firemage.autograder.core.file.CompilationUnit;
import de.firemage.autograder.core.file.SourceInfo;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;

record ErrorProneCompiler(JavaVersion javaVersion, TempLocation tempLocation, List<ErrorProneLint> lints) implements Serializable
{
    List<ErrorProneDiagnostic> compile(SourceInfo input) throws IOException {
        ArrayList diagnostics;
        VMLauncher vmLauncher = VMLauncher.fromDefault(this.tempLocation);
        try {
            diagnostics = vmLauncher.runInNewJVM(() -> new ArrayList<ErrorProneDiagnostic>(this.internalCompile(input))).join();
        }
        catch (InterruptedException exception) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("unreachable");
        }
        return diagnostics;
    }

    private List<ErrorProneDiagnostic> internalCompile(SourceInfo input) throws IOException {
        boolean isSuccessful;
        List<CompilationUnit> compilationUnits = input.compilationUnits();
        Charset charset = compilationUnits.get(0).charset();
        if (compilationUnits.isEmpty()) {
            throw new IllegalArgumentException("Nothing found to compile in " + input.path());
        }
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        DiagnosticCollector diagnosticCollector = new DiagnosticCollector();
        StringWriter output = new StringWriter();
        try (TempLocation tempLocation = this.tempLocation.createTempDirectory("classes");){
            isSuccessful = compiler.getTask(output, compiler.getStandardFileManager(diagnosticCollector, Locale.US, charset), diagnosticCollector, List.of("-processorpath", System.getProperty("java.class.path"), "-d", tempLocation.toPath().toString(), "-XDcompilePolicy=simple", Stream.concat(Stream.of("-Xplugin:ErrorProne", "-XepDisableAllChecks"), this.lints.stream().map(arg_0 -> ErrorProneCompiler.lambda$internalCompile$0("-Xep:%s:WARN", arg_0))).collect(Collectors.joining(" "))), null, compilationUnits.stream().map(CompilationUnit::toJavaFileObject).toList()).call();
        }
        output.flush();
        output.close();
        if (!isSuccessful) {
            throw new IllegalArgumentException("Failed to compile %s: %s".formatted(input.path(), output));
        }
        return diagnosticCollector.getDiagnostics().stream().filter(diagnostic -> diagnostic.getCode().equals("compiler.warn.error.prone")).map(diagnostic -> ErrorProneDiagnostic.from(diagnostic, input)).toList();
    }

    private static /* synthetic */ String lambda$internalCompile$0(String rec$, Object xva$0) {
        return "-Xep:%s:WARN".formatted(xva$0);
    }
}

