/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.oop;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.dynamic.DynamicAnalysis;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import java.util.Map;
import java.util.Optional;
import spoon.processing.AbstractProcessor;
import spoon.reflect.declaration.CtField;

@ExecutableCheck(reportedProblems={ProblemType.STATIC_FIELD_SHOULD_BE_INSTANCE})
public class StaticFieldShouldBeInstanceCheck
extends IntegratedCheck {
    @Override
    protected void check(StaticAnalysis staticAnalysis, DynamicAnalysis dynamicAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtField<?>>(){

            public void process(CtField<?> ctField) {
                if (ctField.isImplicit() || !ctField.getPosition().isValidPosition() || !ctField.isStatic() || ctField.isFinal()) {
                    return;
                }
                if (ctField.getType() != null && SpoonUtil.isTypeEqualTo(ctField.getType().unbox(), Integer.TYPE)) {
                    return;
                }
                if (!SpoonUtil.isEffectivelyFinal(ctField)) {
                    StaticFieldShouldBeInstanceCheck.this.addLocalProblem(ctField, new LocalizedMessage("static-field-should-be-instance", Map.of("name", ctField.getSimpleName())), ProblemType.STATIC_FIELD_SHOULD_BE_INSTANCE);
                }
            }
        });
    }

    @Override
    public Optional<Integer> maximumProblems() {
        return Optional.of(4);
    }
}

