/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.oop;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.dynamic.DynamicAnalysis;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import spoon.processing.AbstractProcessor;
import spoon.reflect.declaration.CtEnum;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtType;

@ExecutableCheck(reportedProblems={ProblemType.MUTABLE_ENUM})
public class MutableEnum
extends IntegratedCheck {
    private static boolean isMutable(CtType<?> ctType) {
        for (CtField ctField : ctType.getFields()) {
            if (SpoonUtil.isEffectivelyFinal(ctField)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void check(StaticAnalysis staticAnalysis, DynamicAnalysis dynamicAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtEnum<?>>(){

            public void process(CtEnum<?> ctEnum) {
                if (MutableEnum.isMutable(ctEnum)) {
                    MutableEnum.this.addLocalProblem(ctEnum, new LocalizedMessage("mutable-enum"), ProblemType.MUTABLE_ENUM);
                }
            }
        });
    }
}

