/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.oop;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.dynamic.DynamicAnalysis;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtCatch;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtTry;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.visitor.CtScanner;
import spoon.reflect.visitor.CtVisitor;

@ExecutableCheck(reportedProblems={ProblemType.INSTANCEOF, ProblemType.INSTANCEOF_EMULATION})
public class InstanceOf
extends IntegratedCheck {
    private static boolean isInAllowedContext(CtElement ctElement) {
        CtMethod ctMethod = (CtMethod)ctElement.getParent(CtMethod.class);
        return ctMethod != null && SpoonUtil.isOverriddenMethod(ctMethod);
    }

    @Override
    protected void check(StaticAnalysis staticAnalysis, DynamicAnalysis dynamicAnalysis) {
        staticAnalysis.getModel().getRootPackage().accept((CtVisitor)new CtScanner(){

            public void visitCtTry(CtTry ctTry) {
                if (ctTry.isImplicit() || !ctTry.getPosition().isValidPosition() || InstanceOf.isInAllowedContext((CtElement)ctTry)) {
                    super.visitCtTry(ctTry);
                    return;
                }
                for (CtCatch ctCatch : ctTry.getCatchers()) {
                    if (!ctCatch.getParameter().getType().equals(ctCatch.getFactory().Type().createReference(ClassCastException.class))) continue;
                    InstanceOf.this.addLocalProblem((CtElement)ctCatch, new LocalizedMessage("do-not-use-instanceof-emulation"), ProblemType.INSTANCEOF_EMULATION);
                }
                super.visitCtTry(ctTry);
            }

            public <T> void visitCtInvocation(CtInvocation<T> ctInvocation) {
                if (ctInvocation.isImplicit() || !ctInvocation.getPosition().isValidPosition() || InstanceOf.isInAllowedContext(ctInvocation)) {
                    super.visitCtInvocation(ctInvocation);
                    return;
                }
                CtExecutableReference ctExecutableReference = ctInvocation.getExecutable();
                if (ctExecutableReference.getType().getQualifiedName().equals("java.lang.Class") && ctExecutableReference.getSimpleName().equals("getClass")) {
                    InstanceOf.this.addLocalProblem(ctInvocation, new LocalizedMessage("do-not-use-instanceof-emulation"), ProblemType.INSTANCEOF_EMULATION);
                }
                super.visitCtInvocation(ctInvocation);
            }

            public <T> void visitCtBinaryOperator(CtBinaryOperator<T> ctBinaryOperator) {
                if (ctBinaryOperator.isImplicit() || !ctBinaryOperator.getPosition().isValidPosition() || InstanceOf.isInAllowedContext(ctBinaryOperator)) {
                    super.visitCtBinaryOperator(ctBinaryOperator);
                    return;
                }
                if (ctBinaryOperator.getKind() == BinaryOperatorKind.INSTANCEOF) {
                    InstanceOf.this.addLocalProblem(ctBinaryOperator, new LocalizedMessage("do-not-use-instanceof"), ProblemType.INSTANCEOF);
                }
                super.visitCtBinaryOperator(ctBinaryOperator);
            }
        });
    }
}

