/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.oop;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.Translatable;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.dynamic.DynamicAnalysis;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import spoon.reflect.CtModel;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldRead;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtTypeAccess;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtType;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.filter.CompositeFilter;
import spoon.reflect.visitor.filter.FilteringOperator;
import spoon.reflect.visitor.filter.TypeFilter;

@ExecutableCheck(reportedProblems={ProblemType.UI_INPUT_SEPARATION, ProblemType.UI_OUTPUT_SEPARATION})
public class IOUISeparation
extends IntegratedCheck {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean hasAccessedSystem(CtInvocation<?> ctInvocation) {
        CtExpression ctExpression = ctInvocation.getTarget();
        if (!(ctExpression instanceof CtFieldRead)) return false;
        CtFieldRead ctFieldRead = (CtFieldRead)ctExpression;
        if (!((ctExpression = ctFieldRead.getTarget()) instanceof CtTypeAccess)) return false;
        CtTypeAccess ctTypeAccess = (CtTypeAccess)ctExpression;
        if (!List.of("out", "err").contains(ctFieldRead.getVariable().getSimpleName())) return false;
        if (!ctFieldRead.getVariable().isStatic()) return false;
        if (!ctFieldRead.getVariable().isFinal()) return false;
        if (!SpoonUtil.isTypeEqualTo(ctTypeAccess.getAccessedType(), System.class)) return false;
        return true;
    }

    private boolean hasAccessedScanner(CtInvocation<?> ctInvocation) {
        CtVariableRead ctVariableRead;
        CtExpression ctExpression = ctInvocation.getTarget();
        return ctExpression instanceof CtVariableRead && (ctVariableRead = (CtVariableRead)ctExpression).getVariable() != null && SpoonUtil.isTypeEqualTo(ctVariableRead.getVariable().getType(), Scanner.class);
    }

    private static boolean isAllowedLocation(boolean requireSameClass, List<? extends CtElement> uses) {
        if (uses.isEmpty()) {
            return true;
        }
        CtElement firstElement = uses.get(0);
        CtElement commonParent = SpoonUtil.findCommonParent(firstElement, uses.subList(1, uses.size()));
        CtModel ctModel = commonParent.getFactory().getModel();
        if (requireSameClass) {
            return IOUISeparation.getThisOrParent(commonParent, CtType.class) != null;
        }
        CtPackage commonPackage = IOUISeparation.getThisOrParent(commonParent, CtPackage.class);
        if (ctModel.getRootPackage().equals(commonPackage)) {
            for (CtElement ctElement : uses) {
                CtPackage parent = IOUISeparation.getThisOrParent(ctElement, CtPackage.class);
                if (ctModel.getRootPackage().equals(parent)) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    private static <P extends CtElement> P getThisOrParent(CtElement ctElement, Class<P> parentType) {
        if (parentType.isInstance(ctElement)) {
            return (P)ctElement;
        }
        return (P)ctElement.getParent(parentType);
    }

    private static CtElement findViolation(List<? extends CtElement> ctElements, boolean requireSameClass) {
        CtElement firstElement = ctElements.get(0);
        for (CtElement ctElement : ctElements) {
            if (IOUISeparation.isAllowedLocation(requireSameClass, List.of(firstElement, ctElement))) continue;
            return ctElement;
        }
        throw new IllegalStateException("No violation found");
    }

    private boolean notInMainClass(CtElement ctElement) {
        CtType type = IOUISeparation.getThisOrParent(ctElement, CtType.class);
        if (type != null && type.getDeclaringType() != null) {
            type = type.getDeclaringType();
        }
        return type == null || type.getMethods().stream().noneMatch(SpoonUtil::isMainMethod);
    }

    @Override
    protected void check(StaticAnalysis staticAnalysis, DynamicAnalysis dynamicAnalysis) {
        CtModel ctModel = staticAnalysis.getModel();
        boolean requireSameClass = true;
        CtPackage currentPackage = null;
        for (CtType ctType : ctModel.getAllTypes()) {
            if (currentPackage == null) {
                currentPackage = ctType.getPackage();
            }
            if (ctType.getPackage().equals(currentPackage)) continue;
            requireSameClass = false;
            break;
        }
        List scannerUses = ctModel.filterChildren((Filter)new CompositeFilter(FilteringOperator.INTERSECTION, new Filter[]{new TypeFilter(CtType.class), this::notInMainClass})).filterChildren((Filter)new CompositeFilter(FilteringOperator.INTERSECTION, new Filter[]{new TypeFilter(CtInvocation.class), this::hasAccessedScanner})).list(CtInvocation.class);
        List printUses = ctModel.filterChildren((Filter)new CompositeFilter(FilteringOperator.INTERSECTION, new Filter[]{new TypeFilter(CtType.class), this::notInMainClass})).filterChildren((Filter)new CompositeFilter(FilteringOperator.INTERSECTION, new Filter[]{new TypeFilter(CtInvocation.class), this::hasAccessedSystem})).list(CtInvocation.class);
        if (!IOUISeparation.isAllowedLocation(requireSameClass, scannerUses)) {
            this.addLocalProblem(IOUISeparation.findViolation(scannerUses, requireSameClass), (Translatable)new LocalizedMessage("ui-input-separation", Map.of("first", SpoonUtil.formatSourcePosition(((CtInvocation)scannerUses.get(0)).getPosition()))), ProblemType.UI_INPUT_SEPARATION);
        }
        if (!IOUISeparation.isAllowedLocation(requireSameClass, printUses)) {
            this.addLocalProblem(IOUISeparation.findViolation(printUses, requireSameClass), (Translatable)new LocalizedMessage("ui-output-separation", Map.of("first", SpoonUtil.formatSourcePosition(((CtInvocation)printUses.get(0)).getPosition()))), ProblemType.UI_OUTPUT_SEPARATION);
        }
    }
}

