/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.oop;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.Translatable;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.dynamic.DynamicAnalysis;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Stream;
import spoon.processing.FactoryAccessor;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtArrayAccess;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtConstructorCall;
import spoon.reflect.code.CtExecutableReferenceExpression;
import spoon.reflect.code.CtFieldAccess;
import spoon.reflect.code.CtFieldRead;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtNewArray;
import spoon.reflect.code.CtSuperAccess;
import spoon.reflect.code.CtThisAccess;
import spoon.reflect.code.CtTypeAccess;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtRecord;
import spoon.reflect.declaration.CtTypeInformation;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.path.CtRole;
import spoon.reflect.reference.CtArrayTypeReference;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtScanner;
import spoon.reflect.visitor.CtVisitor;

@ExecutableCheck(reportedProblems={ProblemType.CONCRETE_COLLECTION_AS_FIELD_OR_RETURN_VALUE})
public class ConcreteCollectionCheck
extends IntegratedCheck {
    private static final List<Class<?>> ALLOWED_TYPES = List.of(Properties.class);

    private <T extends CtTypeInformation & FactoryAccessor> boolean isConcreteCollectionType(T ctType) {
        if (ctType instanceof CtArrayTypeReference) {
            return false;
        }
        return Stream.of(Collection.class, Map.class).map(ty -> ((FactoryAccessor)ctType).getFactory().Type().createReference(ty, false)).anyMatch(arg_0 -> ctType.isSubtypeOf(arg_0)) && !ctType.isInterface();
    }

    private boolean isAllowedType(CtTypeReference<?> ctTypeReference) {
        return ALLOWED_TYPES.stream().map(ty -> ctTypeReference.getFactory().Type().createReference(ty, false)).anyMatch(ctTypeReference::equals);
    }

    private boolean isInAllowedContext(CtTypeReference<?> ctTypeReference) {
        CtClass parentType;
        CtConstructorCall ctConstructorCall = (CtConstructorCall)ctTypeReference.getParent(CtConstructorCall.class);
        if (ctConstructorCall != null && ctTypeReference.equals((Object)ctConstructorCall.getType())) {
            return true;
        }
        if (ctTypeReference.getParent(CtExecutableReferenceExpression.class) != null || ctTypeReference.getParent(CtExecutableReference.class) != null) {
            return true;
        }
        CtInvocation ctInvocation = (CtInvocation)ctTypeReference.getParent(CtInvocation.class);
        if (ctInvocation != null && ctInvocation.getTarget() != null && ctInvocation.getTarget().equals(ctTypeReference.getParent(CtTypeAccess.class))) {
            return true;
        }
        if (ctTypeReference.getParent(CtNewArray.class) != null) {
            return true;
        }
        CtVariable ctVariable = (CtVariable)ctTypeReference.getParent(CtVariable.class);
        if (ctVariable != null && ctVariable.getDefaultExpression() != null && ctVariable.getDefaultExpression().getTypeCasts().contains(ctTypeReference)) {
            return true;
        }
        CtVariableRead ctVariableRead = (CtVariableRead)ctTypeReference.getParent(CtVariableRead.class);
        if (ctVariableRead != null && ctVariableRead.getTypeCasts().contains(ctTypeReference)) {
            return true;
        }
        if (ctTypeReference.getParent(CtArrayTypeReference.class) != null && (ctTypeReference.getParent(CtVariableAccess.class) != null || ctTypeReference.getParent(CtArrayAccess.class) != null || ctTypeReference.getParent(CtFieldAccess.class) != null)) {
            return true;
        }
        CtFieldRead ctFieldRead = (CtFieldRead)ctTypeReference.getParent(CtFieldRead.class);
        if (ctFieldRead != null) {
            CtFieldReference ctFieldReference = ctFieldRead.getVariable();
            return ctFieldReference.getDeclaringType().equals(ctTypeReference) && ctFieldReference.getType().equals(ctTypeReference.getFactory().Type().createReference(Class.class, false));
        }
        CtTypeReference parentTypeReference = (CtTypeReference)ctTypeReference.getParent(CtTypeReference.class);
        if (parentTypeReference != null) {
            return ctTypeReference.equals((Object)parentTypeReference.getDeclaringType());
        }
        CtBinaryOperator ctBinaryOperator = (CtBinaryOperator)ctTypeReference.getParent(CtBinaryOperator.class);
        if (ctBinaryOperator != null) {
            return ctBinaryOperator.getKind() == BinaryOperatorKind.INSTANCEOF;
        }
        CtElement parent = ctTypeReference.getParent();
        if (parent == null) {
            return false;
        }
        if (parent instanceof CtClass && (parentType = (CtClass)parent).getSuperclass() != null) {
            return parentType.getSuperclass().equals(ctTypeReference);
        }
        return ctTypeReference.getParent(CtSuperAccess.class) != null || ctTypeReference.getParent(CtThisAccess.class) != null;
    }

    private boolean checkCtTypeReference(CtTypeReference<?> ctTypeReference) {
        if (!ctTypeReference.getPosition().isValidPosition() && ctTypeReference.getParent(CtArrayTypeReference.class) == null) {
            return true;
        }
        if (SpoonUtil.isInOverriddenMethod(ctTypeReference) || this.isInAllowedContext((CtTypeReference<?>)ctTypeReference) || this.isAllowedType((CtTypeReference<?>)ctTypeReference)) {
            return false;
        }
        if (!this.isConcreteCollectionType(ctTypeReference)) {
            Object ctArrayTypeReference;
            if (ctTypeReference instanceof CtArrayTypeReference && this.checkCtTypeReference((ctArrayTypeReference = (CtArrayTypeReference)ctTypeReference).getArrayType())) {
                return true;
            }
            for (CtTypeReference typeArgument : ctTypeReference.getActualTypeArguments()) {
                if (!this.checkCtTypeReference(typeArgument)) continue;
                return true;
            }
            return false;
        }
        CtElement element = ctTypeReference;
        while (!element.getPosition().isValidPosition() && element.getParent(CtArrayTypeReference.class) != null) {
            element = element.getParent(CtArrayTypeReference.class);
        }
        this.addLocalProblem(element, (Translatable)new LocalizedMessage("concrete-collection", Map.of("type", ctTypeReference.prettyprint())), ProblemType.CONCRETE_COLLECTION_AS_FIELD_OR_RETURN_VALUE);
        return true;
    }

    @Override
    protected void check(StaticAnalysis staticAnalysis, DynamicAnalysis dynamicAnalysis) {
        staticAnalysis.getModel().getRootPackage().accept((CtVisitor)new CtScanner(){

            public <T> void visitCtMethod(CtMethod<T> ctMethod) {
                if (ctMethod.isImplicit() || !ctMethod.getPosition().isValidPosition()) {
                    super.visitCtMethod(ctMethod);
                    return;
                }
                boolean hasError = ConcreteCollectionCheck.this.checkCtTypeReference(ctMethod.getType());
                if (hasError) {
                    this.enter((CtElement)ctMethod);
                    this.scan(CtRole.ANNOTATION, ctMethod.getAnnotations());
                    this.scan(CtRole.TYPE_PARAMETER, ctMethod.getFormalCtTypeParameters());
                    this.scan(CtRole.PARAMETER, ctMethod.getParameters());
                    this.scan(CtRole.THROWN, ctMethod.getThrownTypes());
                    this.scan(CtRole.BODY, (CtElement)ctMethod.getBody());
                    this.scan(CtRole.COMMENT, ctMethod.getComments());
                    this.exit((CtElement)ctMethod);
                    return;
                }
                super.visitCtMethod(ctMethod);
            }

            public <T> void visitCtField(CtField<T> ctVariable) {
                boolean hasError = ConcreteCollectionCheck.this.checkCtTypeReference(ctVariable.getType());
                if (!hasError) {
                    super.visitCtField(ctVariable);
                }
            }

            public <T> void visitCtLocalVariable(CtLocalVariable<T> ctVariable) {
                if (ctVariable.isInferred()) {
                    super.visitCtLocalVariable(ctVariable);
                    return;
                }
                boolean hasError = ConcreteCollectionCheck.this.checkCtTypeReference(ctVariable.getType());
                if (!hasError) {
                    super.visitCtLocalVariable(ctVariable);
                }
            }

            public <T> void visitCtParameter(CtParameter<T> ctVariable) {
                if (ctVariable.isImplicit() || !ctVariable.getPosition().isValidPosition()) {
                    super.visitCtParameter(ctVariable);
                    return;
                }
                boolean hasError = ConcreteCollectionCheck.this.checkCtTypeReference(ctVariable.getType());
                if (!hasError) {
                    super.visitCtParameter(ctVariable);
                }
            }

            public void visitCtRecord(CtRecord ctRecord) {
                this.enter((CtElement)ctRecord);
                this.scan(CtRole.ANNOTATION, ctRecord.getAnnotations());
                this.scan(CtRole.INTERFACE, ctRecord.getSuperInterfaces());
                this.scan(CtRole.TYPE_PARAMETER, ctRecord.getFormalCtTypeParameters());
                ctRecord.getFields().forEach(this::visitCtField);
                this.scan(CtRole.COMMENT, ctRecord.getComments());
                this.exit((CtElement)ctRecord);
            }
        });
    }

    @Override
    public Optional<Integer> maximumProblems() {
        return Optional.of(5);
    }
}

