/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.oop;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.Translatable;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.dynamic.DynamicAnalysis;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import de.firemage.autograder.core.integrated.effects.Effect;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import spoon.reflect.code.CtAbstractSwitch;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtNewArray;
import spoon.reflect.code.CtReturn;
import spoon.reflect.code.CtSwitch;
import spoon.reflect.code.CtSwitchExpression;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtScanner;
import spoon.reflect.visitor.CtVisitor;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.filter.TypeFilter;

@ExecutableCheck(reportedProblems={ProblemType.CLOSED_SET_OF_VALUES})
public class ClosedSetOfValues
extends IntegratedCheck {
    private static final int MIN_SET_SIZE = 3;
    private static final int MAX_SET_SIZE = 12;
    private static final List<Class<?>> SUPPORTED_TYPES = List.of(String.class, Character.class, Character.TYPE);

    private static boolean isSupportedType(CtTypeReference<?> ctTypeReference) {
        return SUPPORTED_TYPES.stream().map(e -> ctTypeReference.getFactory().Type().createReference(e)).anyMatch(ctTypeReference::equals);
    }

    private boolean isEnumMapping(CtAbstractSwitch<?> ctSwitch) {
        List<Effect> effects = SpoonUtil.getCasesEffects(ctSwitch.getCases());
        if (effects.isEmpty()) {
            return false;
        }
        Effect firstEffect = effects.get(0);
        for (Effect effect : effects) {
            if (!firstEffect.isSameEffect(effect)) {
                return false;
            }
            CtExpression ctExpression = effect.value().orElse(null);
            if (ctExpression == null) {
                return false;
            }
            if (ctExpression.getType().equals(ctExpression.getFactory().Type().nullType())) {
                return false;
            }
            if (ctExpression.getType().isEnum()) continue;
            return false;
        }
        return true;
    }

    private void checkSwitch(CtAbstractSwitch<?> ctSwitch) {
        CtTypeReference ctTypeReference = ctSwitch.getSelector().getType();
        if (!ClosedSetOfValues.isSupportedType(ctTypeReference)) {
            return;
        }
        int numberOfCases = ctSwitch.getCases().size();
        if (numberOfCases < 3 || numberOfCases > 12) {
            return;
        }
        boolean areKnown = ctSwitch.getCases().stream().flatMap(e -> e.getCaseExpressions().stream()).map(SpoonUtil::resolveCtExpression).allMatch(e -> e instanceof CtLiteral);
        if (areKnown && !this.isEnumMapping(ctSwitch)) {
            this.addLocalProblem((CtElement)ctSwitch, (Translatable)new LocalizedMessage("closed-set-of-values-switch"), ProblemType.CLOSED_SET_OF_VALUES);
        }
    }

    private static Set<CtLiteral<?>> distinctElements(Collection<? extends CtLiteral<?>> elements) {
        return new LinkedHashSet(elements.stream().filter(e -> e.getValue() != null).toList());
    }

    private static boolean isFiniteSet(Collection<? extends CtLiteral<?>> distinctElements) {
        return distinctElements.size() >= 3 && distinctElements.size() <= 12;
    }

    private static List<CtLiteral<?>> getFiniteSet(Iterable<? extends CtExpression<?>> elements) {
        ArrayList result = new ArrayList();
        for (CtExpression<?> ctExpression : elements) {
            CtExpression<?> resolved = SpoonUtil.resolveCtExpression(ctExpression);
            if (!ClosedSetOfValues.isSupportedType(resolved.getType()) || !(resolved instanceof CtLiteral)) {
                return List.of();
            }
            CtLiteral ctLiteral = (CtLiteral)resolved;
            result.add(ctLiteral);
        }
        return result;
    }

    private void checkFiniteListing(CtExpression<?> ctExpression, Iterable<? extends CtExpression<?>> values) {
        List<CtLiteral<?>> literals = ClosedSetOfValues.getFiniteSet(values);
        Set<CtLiteral<?>> distinctElements = ClosedSetOfValues.distinctElements(literals);
        if (literals.isEmpty() || !ClosedSetOfValues.isFiniteSet(distinctElements)) {
            return;
        }
        this.addLocalProblem((CtElement)ctExpression, (Translatable)new LocalizedMessage("closed-set-of-values-list"), ProblemType.CLOSED_SET_OF_VALUES);
    }

    private void checkCtMethod(CtMethod<?> ctMethod) {
        CtTypeReference returnType = ctMethod.getType();
        if (returnType == null || !ClosedSetOfValues.isSupportedType(returnType)) {
            return;
        }
        List ctReturns = ctMethod.getElements((Filter)new TypeFilter(CtReturn.class));
        List<CtLiteral<?>> literals = ClosedSetOfValues.getFiniteSet(ctReturns.stream().map(CtReturn::getReturnedExpression).toList());
        Set<CtLiteral<?>> distinctElements = ClosedSetOfValues.distinctElements(literals);
        if (literals.isEmpty() || !ClosedSetOfValues.isFiniteSet(distinctElements)) {
            return;
        }
        this.addLocalProblem((CtElement)ctMethod, (Translatable)new LocalizedMessage("closed-set-of-values-method", Map.of("values", distinctElements.stream().map(CtElement::prettyprint).collect(Collectors.joining(", ")))), ProblemType.CLOSED_SET_OF_VALUES);
    }

    @Override
    protected void check(StaticAnalysis staticAnalysis, DynamicAnalysis dynamicAnalysis) {
        staticAnalysis.getModel().getRootPackage().accept((CtVisitor)new CtScanner(){

            public <S> void visitCtSwitch(CtSwitch<S> switchStatement) {
                ClosedSetOfValues.this.checkSwitch((CtAbstractSwitch<?>)switchStatement);
                super.visitCtSwitch(switchStatement);
            }

            public <T, S> void visitCtSwitchExpression(CtSwitchExpression<T, S> switchExpression) {
                ClosedSetOfValues.this.checkSwitch((CtAbstractSwitch<?>)switchExpression);
                super.visitCtSwitchExpression(switchExpression);
            }

            public <T> void visitCtField(CtField<T> ctField) {
                if (!SpoonUtil.isEffectivelyFinal(ctField)) {
                    return;
                }
                CtExpression ctExpression = ctField.getDefaultExpression();
                if (ctExpression == null) {
                    return;
                }
                if (ctExpression.isImplicit()) {
                    return;
                }
                if (ctField.getType().isArray() && ctExpression instanceof CtNewArray) {
                    CtNewArray ctNewArray = (CtNewArray)ctExpression;
                    ClosedSetOfValues.this.checkFiniteListing(ctExpression, ctNewArray.getElements());
                } else {
                    ClosedSetOfValues.this.checkFiniteListing(ctExpression, SpoonUtil.getElementsOfExpression(ctExpression));
                }
                super.visitCtField(ctField);
            }

            public <T> void visitCtLocalVariable(CtLocalVariable<T> ctLocalVariable) {
                if (!SpoonUtil.isEffectivelyFinal(ctLocalVariable)) {
                    return;
                }
                CtExpression ctExpression = ctLocalVariable.getDefaultExpression();
                if (ctExpression == null) {
                    return;
                }
                if (ctExpression.isImplicit()) {
                    return;
                }
                if (ctLocalVariable.getType().isArray() && ctExpression instanceof CtNewArray) {
                    CtNewArray ctNewArray = (CtNewArray)ctExpression;
                    ClosedSetOfValues.this.checkFiniteListing(ctExpression, ctNewArray.getElements());
                } else {
                    ClosedSetOfValues.this.checkFiniteListing(ctExpression, SpoonUtil.getElementsOfExpression(ctExpression));
                }
                super.visitCtLocalVariable(ctLocalVariable);
            }

            public <T> void visitCtMethod(CtMethod<T> ctMethod) {
                ClosedSetOfValues.this.checkCtMethod(ctMethod);
                super.visitCtMethod(ctMethod);
            }
        });
    }
}

