/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.naming;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.Translatable;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.dynamic.DynamicAnalysis;
import de.firemage.autograder.core.integrated.IdentifierNameUtils;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import spoon.processing.AbstractProcessor;
import spoon.reflect.code.CtCatchVariable;
import spoon.reflect.code.CtLambda;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtStatementList;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtNamedElement;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.path.CtRole;
import spoon.reflect.reference.CtTypeReference;

@ExecutableCheck(reportedProblems={ProblemType.SINGLE_LETTER_LOCAL_NAME, ProblemType.IDENTIFIER_IS_ABBREVIATED_TYPE, ProblemType.IDENTIFIER_CONTAINS_TYPE_NAME, ProblemType.SIMILAR_IDENTIFIER, ProblemType.IDENTIFIER_REDUNDANT_NUMBER_SUFFIX})
public class VariablesHaveDescriptiveNamesCheck
extends IntegratedCheck {
    private static final Set<String> ALLOWED_IDENTIFIER = Set.of("x1", "x2", "x3", "y1", "y2", "y3", "z1", "z2", "z3", "ui");
    private static final List<String> TYPE_NAMES = List.of("string", "list", "array", "map", "set", "int", "long", "float");
    private static final Set<String> ALLOWED_NAMES_WITH_TYPES = Set.of("subList", "subString");
    private static final Set<String> KNOWN_ABBREVIATIONS = Set.of("sec", "min");
    private static final Set<String> ALLOWED_SIMILAR_IDENTIFIER = Set.of("july", "june");
    private static final Set<String> ALLOWED_SIMILAR_IDENTIFIER_CONTAINS = Set.of("max", "min", "maximum", "minimum");
    private final Set<String> similarIdentifier = new HashSet<String>();

    private static Set<String> typeNameAlternatives(String typeName) {
        HashSet<String> result = new HashSet<String>(Set.of(typeName));
        if (!typeName.endsWith("s")) {
            result.add(typeName + "s");
        }
        if (typeName.equals("int")) {
            result.addAll(VariablesHaveDescriptiveNamesCheck.typeNameAlternatives("integer"));
        }
        return result;
    }

    private static boolean hasTypeInName(CtNamedElement ctVariable) {
        if (ALLOWED_NAMES_WITH_TYPES.contains(ctVariable.getSimpleName())) {
            return false;
        }
        List referencedTypeNames = ctVariable.getReferencedTypes().stream().map(CtTypeReference::getSimpleName).map(String::toLowerCase).filter(TYPE_NAMES::contains).flatMap(name -> VariablesHaveDescriptiveNamesCheck.typeNameAlternatives(name).stream()).toList();
        Set words = IdentifierNameUtils.split(ctVariable.getSimpleName()).collect(Collectors.toSet());
        if (words.size() == 1) {
            return false;
        }
        return referencedTypeNames.stream().anyMatch(words::contains);
    }

    private static boolean isLambdaParameter(CtVariable<?> variable) {
        return variable instanceof CtParameter && variable.getParent() instanceof CtLambda;
    }

    private static boolean isCoordinate(CtVariable<?> variable) {
        return variable.getSimpleName().equals("x") || variable.getSimpleName().equals("y");
    }

    private static boolean isAllowedLoopCounter(CtVariable<?> variable) {
        CtRole role = variable.getRoleInParent();
        if (role != CtRole.FOR_INIT && role != CtRole.FOREACH_VARIABLE) {
            return false;
        }
        if (variable.getType().getQualifiedName().equals("char") && variable.getSimpleName().equals("c")) {
            return true;
        }
        return SpoonUtil.isPrimitiveNumeric(variable.getType());
    }

    private static boolean isAbbreviation(CtVariable<?> variable) {
        if (KNOWN_ABBREVIATIONS.contains(variable.getSimpleName())) {
            return true;
        }
        if (variable.getType().isPrimitive()) {
            return false;
        }
        String name = variable.getSimpleName();
        String type = variable.getType().getSimpleName();
        String[] parts = StringUtils.splitByCharacterTypeCamelCase((String)type);
        if (parts[0].length() >= 4 && name.length() <= 3 && parts[0].toLowerCase().indexOf(name) == 0) {
            return true;
        }
        if (parts.length == name.length()) {
            for (int i = 0; i < parts.length; ++i) {
                if (parts[i].toLowerCase().charAt(0) == name.charAt(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static int similarity(CtNamedElement variable, CtNamedElement other) {
        String name = variable.getSimpleName();
        String otherName = other.getSimpleName();
        int similarity = 0;
        if (name.length() != otherName.length()) {
            similarity += Math.abs(name.length() - otherName.length());
        }
        for (int i = 0; i < Math.min(name.length(), otherName.length()); ++i) {
            if (name.charAt(i) == otherName.charAt(i)) continue;
            ++similarity;
        }
        return similarity;
    }

    private static boolean areSimilar(CtNamedElement variable, CtNamedElement other) {
        block5: {
            block4: {
                if (ALLOWED_SIMILAR_IDENTIFIER.contains(variable.getSimpleName().toLowerCase()) || ALLOWED_SIMILAR_IDENTIFIER.contains(other.getSimpleName().toLowerCase())) {
                    return false;
                }
                if (ALLOWED_SIMILAR_IDENTIFIER_CONTAINS.stream().anyMatch(variable.getSimpleName().toLowerCase()::contains)) break block4;
                if (!ALLOWED_SIMILAR_IDENTIFIER_CONTAINS.stream().anyMatch(other.getSimpleName().toLowerCase()::contains)) break block5;
            }
            return false;
        }
        return VariablesHaveDescriptiveNamesCheck.similarity(variable, other) <= 1;
    }

    private static <I, O> Stream<O> filterByType(Stream<I> stream, Class<? extends O> type) {
        return stream.filter(type::isInstance).map(type::cast);
    }

    private static List<CtNamedElement> getSiblings(CtNamedElement ctNamedElement) {
        CtLocalVariable ctLocalVariable;
        CtElement ctElement;
        ArrayList<CtNamedElement> result = new ArrayList<CtNamedElement>();
        if (ctNamedElement instanceof CtParameter) {
            CtExecutable ctExecutable;
            CtParameter ctParameter = (CtParameter)ctNamedElement;
            ctElement = ctNamedElement.getParent();
            if (ctElement instanceof CtExecutable && (ctExecutable = (CtExecutable)ctElement).getParameters().contains(ctParameter)) {
                result.addAll(ctExecutable.getParameters());
                result.remove(ctParameter);
                return result;
            }
        }
        if (ctNamedElement instanceof CtField) {
            CtField ctField = (CtField)ctNamedElement;
            CtType ctType = ctField.getDeclaringType();
            if (ctType == null) {
                return result;
            }
            result.addAll(ctType.getFields());
            result.remove(ctField);
            return result;
        }
        if (ctNamedElement instanceof CtLocalVariable && (ctElement = (ctLocalVariable = (CtLocalVariable)ctNamedElement).getParent()) instanceof CtStatementList) {
            CtStatementList ctStatementList = (CtStatementList)ctElement;
            result.addAll(VariablesHaveDescriptiveNamesCheck.filterByType(ctStatementList.getStatements().stream(), CtVariable.class).toList());
            result.remove(ctLocalVariable);
            return result;
        }
        return result;
    }

    private static String removeNumberSuffix(String name) {
        return name.replaceAll("\\d*$", "");
    }

    private static boolean hasRedundantNumberSuffix(CtNamedElement ctVariable) {
        String name = ctVariable.getSimpleName();
        String nameWithoutNumbers = VariablesHaveDescriptiveNamesCheck.removeNumberSuffix(name);
        if (nameWithoutNumbers.equals(name) || nameWithoutNumbers.isEmpty()) {
            return false;
        }
        return VariablesHaveDescriptiveNamesCheck.getSiblings(ctVariable).stream().map(CtNamedElement::getSimpleName).map(VariablesHaveDescriptiveNamesCheck::removeNumberSuffix).noneMatch(nameWithoutNumbers::equals);
    }

    private void reportProblem(String key, CtNamedElement ctVariable, ProblemType problemType) {
        this.addLocalProblem((CtElement)ctVariable, (Translatable)new LocalizedMessage(key, Map.of("name", ctVariable.getSimpleName())), problemType);
    }

    @Override
    protected void check(StaticAnalysis staticAnalysis, DynamicAnalysis dynamicAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtVariable<?>>(){

            public void process(CtVariable<?> ctVariable) {
                if (ctVariable.isImplicit() || !ctVariable.getPosition().isValidPosition()) {
                    return;
                }
                if (ctVariable instanceof CtCatchVariable || VariablesHaveDescriptiveNamesCheck.isLambdaParameter(ctVariable)) {
                    return;
                }
                if (SpoonUtil.isInOverriddenMethod(ctVariable)) {
                    return;
                }
                if (ALLOWED_IDENTIFIER.contains(ctVariable.getSimpleName())) {
                    return;
                }
                if (ctVariable.getSimpleName().length() == 1 && !VariablesHaveDescriptiveNamesCheck.isAllowedLoopCounter(ctVariable) && !VariablesHaveDescriptiveNamesCheck.isCoordinate(ctVariable)) {
                    VariablesHaveDescriptiveNamesCheck.this.reportProblem("variable-name-single-letter", (CtNamedElement)ctVariable, ProblemType.SINGLE_LETTER_LOCAL_NAME);
                    return;
                }
                if (VariablesHaveDescriptiveNamesCheck.isAbbreviation(ctVariable)) {
                    VariablesHaveDescriptiveNamesCheck.this.reportProblem("variable-is-abbreviation", (CtNamedElement)ctVariable, ProblemType.IDENTIFIER_IS_ABBREVIATED_TYPE);
                    return;
                }
                if (VariablesHaveDescriptiveNamesCheck.hasTypeInName(ctVariable)) {
                    VariablesHaveDescriptiveNamesCheck.this.reportProblem("variable-name-type-in-name", (CtNamedElement)ctVariable, ProblemType.IDENTIFIER_CONTAINS_TYPE_NAME);
                    return;
                }
                if (VariablesHaveDescriptiveNamesCheck.hasRedundantNumberSuffix(ctVariable)) {
                    VariablesHaveDescriptiveNamesCheck.this.reportProblem("variable-redundant-number-suffix", (CtNamedElement)ctVariable, ProblemType.IDENTIFIER_REDUNDANT_NUMBER_SUFFIX);
                    return;
                }
                if (!VariablesHaveDescriptiveNamesCheck.this.similarIdentifier.contains(ctVariable.getSimpleName())) {
                    for (CtNamedElement sibling : VariablesHaveDescriptiveNamesCheck.getSiblings(ctVariable)) {
                        if (!VariablesHaveDescriptiveNamesCheck.areSimilar(ctVariable, sibling) || VariablesHaveDescriptiveNamesCheck.this.similarIdentifier.contains(sibling.getSimpleName())) continue;
                        VariablesHaveDescriptiveNamesCheck.this.addLocalProblem((CtElement)sibling, new LocalizedMessage("similar-identifier", Map.of("left", ctVariable.getSimpleName(), "right", sibling.getSimpleName())), ProblemType.SIMILAR_IDENTIFIER);
                        VariablesHaveDescriptiveNamesCheck.this.similarIdentifier.add(ctVariable.getSimpleName());
                        VariablesHaveDescriptiveNamesCheck.this.similarIdentifier.add(sibling.getSimpleName());
                    }
                    return;
                }
            }
        });
    }
}

