/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.naming;

import de.firemage.autograder.core.CodePosition;
import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.Translatable;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.dynamic.DynamicAnalysis;
import de.firemage.autograder.core.integrated.IdentifierNameUtils;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import spoon.processing.AbstractProcessor;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtStatement;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtNamedElement;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.reference.CtTypeReference;

@ExecutableCheck(reportedProblems={ProblemType.CONFUSING_IDENTIFIER})
public class LinguisticNamingCheck
extends IntegratedCheck {
    private static final Set<String> IGNORE_VARIABLES_WITH = Set.of("regex", "pattern");
    private static final Set<String> COMMON_BOOLEAN_GETTER_PREFIXES = Set.of("is", "are", "can", "could", "must", "has", "have", "does", "will", "should", "would", "takes", "looks", "uses", "finds");

    private static boolean hasBooleanPrefix(CtNamedElement ctNamedElement) {
        String name = ctNamedElement.getSimpleName();
        return IdentifierNameUtils.split(name).findFirst().map(COMMON_BOOLEAN_GETTER_PREFIXES::contains).orElse(false);
    }

    private void reportProblem(String key, CtNamedElement ctNamedElement) {
        this.reportProblem(key, ctNamedElement, Map.of());
    }

    private void reportProblem(String key, CtNamedElement ctNamedElement, Map<String, String> extraArguments) {
        HashMap<String, String> arguments = new HashMap<String, String>(extraArguments);
        arguments.put("name", ctNamedElement.getSimpleName());
        this.addLocalProblem(CodePosition.fromSourcePosition(SpoonUtil.getNamePosition(ctNamedElement), (CtElement)ctNamedElement, this.getRoot()), (Translatable)new LocalizedMessage(key, arguments), ProblemType.CONFUSING_IDENTIFIER);
    }

    private <T> void checkCtVariable(CtVariable<T> ctVariable) {
        if (IGNORE_VARIABLES_WITH.stream().anyMatch(s -> ctVariable.getSimpleName().toLowerCase().contains((CharSequence)s))) {
            return;
        }
        if (LinguisticNamingCheck.hasBooleanPrefix(ctVariable) && !SpoonUtil.isBoolean(ctVariable)) {
            this.reportProblem("linguistic-naming-boolean", (CtNamedElement)ctVariable, Map.of("type", ctVariable.getType().prettyprint()));
        }
    }

    private <T> void checkCtMethod(CtMethod<T> ctMethod) {
        if (SpoonUtil.isOverriddenMethod(ctMethod)) {
            return;
        }
        if (LinguisticNamingCheck.hasBooleanPrefix(ctMethod) && !SpoonUtil.isBoolean(ctMethod)) {
            this.reportProblem("linguistic-naming-boolean", (CtNamedElement)ctMethod, Map.of("type", ctMethod.getType().prettyprint()));
            return;
        }
        List<String> words = IdentifierNameUtils.split(ctMethod.getSimpleName()).toList();
        String prefix = words.get(0);
        if (prefix.equals("get") && SpoonUtil.isTypeEqualTo(ctMethod.getType(), Void.TYPE)) {
            this.reportProblem("linguistic-naming-getter", (CtNamedElement)ctMethod);
            return;
        }
        if (prefix.equals("set") && LinguisticNamingCheck.isInvalidSetterReturnType(ctMethod) && SpoonUtil.getEffectiveStatements((CtStatement)ctMethod.getBody()).size() <= 3) {
            this.reportProblem("linguistic-naming-setter", (CtNamedElement)ctMethod);
        }
    }

    private static boolean isInvalidSetterReturnType(CtMethod<?> ctMethod) {
        CtTypeReference methodType = ctMethod.getType();
        if (SpoonUtil.isTypeEqualTo(methodType, Void.TYPE)) {
            return false;
        }
        if (!ctMethod.isStatic() && ctMethod.getDeclaringType() != null && methodType.equals(ctMethod.getDeclaringType().getReference())) {
            return false;
        }
        if (ctMethod.getParameters().size() == 1 && methodType.equals(((CtParameter)ctMethod.getParameters().get(0)).getType())) {
            return false;
        }
        return !SpoonUtil.isBoolean(ctMethod);
    }

    @Override
    protected void check(StaticAnalysis staticAnalysis, DynamicAnalysis dynamicAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtNamedElement>(){

            public void process(CtNamedElement ctNamedElement) {
                CtField ctVariable;
                if (ctNamedElement.isImplicit() || !ctNamedElement.getPosition().isValidPosition()) {
                    return;
                }
                if (ctNamedElement instanceof CtMethod) {
                    CtMethod ctMethod = (CtMethod)ctNamedElement;
                    LinguisticNamingCheck.this.checkCtMethod(ctMethod);
                }
                if (ctNamedElement instanceof CtField) {
                    ctVariable = (CtField)ctNamedElement;
                    LinguisticNamingCheck.this.checkCtVariable(ctVariable);
                }
                if (ctNamedElement instanceof CtLocalVariable) {
                    ctVariable = (CtLocalVariable)ctNamedElement;
                    LinguisticNamingCheck.this.checkCtVariable(ctVariable);
                }
            }
        });
    }
}

