/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.general;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.Translatable;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.dynamic.DynamicAnalysis;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import de.firemage.autograder.core.integrated.effects.Effect;
import de.firemage.autograder.core.integrated.effects.TerminalEffect;
import java.util.List;
import java.util.Optional;
import spoon.processing.AbstractProcessor;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtIf;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtUnaryOperator;
import spoon.reflect.code.UnaryOperatorKind;
import spoon.reflect.declaration.CtElement;

@ExecutableCheck(reportedProblems={ProblemType.USE_GUARD_CLAUSES})
public class UseGuardClauses
extends IntegratedCheck {
    private void reportProblem(CtStatement ctStatement, CtExpression<?> condition) {
        this.addLocalProblem((CtElement)ctStatement, (Translatable)new LocalizedMessage("use-guard-clauses"), ProblemType.USE_GUARD_CLAUSES);
    }

    private boolean isTerminal(CtStatement ctStatement) {
        List<CtStatement> ctStatements = SpoonUtil.getEffectiveStatements(ctStatement);
        if (ctStatements.isEmpty()) {
            return false;
        }
        Optional<Effect> optionalEffect = SpoonUtil.tryMakeEffect(ctStatements.get(ctStatements.size() - 1));
        return optionalEffect.map(TerminalEffect.class::isInstance).orElse(false);
    }

    private void checkCtIf(CtIf ctIf, CtExpression<?> condition) {
        CtStatement ctStatement;
        if (condition != null) {
            CtBinaryOperator ifCondition = SpoonUtil.createBinaryOperator(condition, ctIf.getCondition(), BinaryOperatorKind.AND);
            if (this.isTerminal(ctIf.getThenStatement())) {
                this.reportProblem(ctIf.getThenStatement(), (CtExpression<?>)ifCondition);
            }
        }
        CtUnaryOperator elseCondition = SpoonUtil.createUnaryOperator(UnaryOperatorKind.NOT, ctIf.getCondition());
        CtStatement ctStatement2 = ctIf.getElseStatement();
        if (ctStatement2 == null) {
            return;
        }
        List<CtStatement> ctStatements = SpoonUtil.getEffectiveStatements(ctStatement2);
        if (condition != null) {
            elseCondition = SpoonUtil.createBinaryOperator(condition, elseCondition, BinaryOperatorKind.AND);
        }
        if (ctStatements.size() == 1 && (ctStatement = ctStatements.get(0)) instanceof CtIf) {
            CtIf ctElseIf = (CtIf)ctStatement;
            CtBinaryOperator elseIfCondition = SpoonUtil.createBinaryOperator(elseCondition, ctElseIf.getCondition(), BinaryOperatorKind.AND);
            this.checkCtIf(ctElseIf, (CtExpression<?>)elseIfCondition);
        } else if (this.isTerminal(ctStatement2)) {
            this.reportProblem(ctStatement2, (CtExpression<?>)elseCondition);
        }
    }

    @Override
    protected void check(StaticAnalysis staticAnalysis, DynamicAnalysis dynamicAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtIf>(){

            public void process(CtIf ctIf) {
                List<CtStatement> ctStatements;
                if (ctIf.isImplicit() || !ctIf.getPosition().isValidPosition()) {
                    return;
                }
                CtIf parentIf = (CtIf)ctIf.getParent(CtIf.class);
                if (parentIf != null && parentIf.getElseStatement() != null && (ctStatements = SpoonUtil.getEffectiveStatements(parentIf.getElseStatement())).size() == 1 && ctStatements.get(0).equals(ctIf)) {
                    return;
                }
                UseGuardClauses.this.checkCtIf(ctIf, null);
            }
        });
    }
}

