/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.general;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.dynamic.DynamicAnalysis;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import java.util.Optional;
import spoon.processing.AbstractProcessor;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtTextBlock;

@ExecutableCheck(reportedProblems={ProblemType.SYSTEM_SPECIFIC_LINE_BREAK})
public class SystemSpecificLineBreak
extends IntegratedCheck {
    @Override
    protected void check(StaticAnalysis staticAnalysis, DynamicAnalysis dynamicAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtLiteral<?>>(){

            public void process(CtLiteral<?> literal) {
                Object value;
                if (literal.isImplicit() || !literal.getPosition().isValidPosition()) {
                    return;
                }
                Object object = literal.getValue();
                if (object instanceof String) {
                    value = (String)object;
                    if (!(literal instanceof CtTextBlock) && (((String)value).contains("\n") || ((String)value).contains("\r") || ((String)value).contains("\\n") || ((String)value).contains("\\r"))) {
                        SystemSpecificLineBreak.this.addLocalProblem(literal, new LocalizedMessage("system-specific-linebreak"), ProblemType.SYSTEM_SPECIFIC_LINE_BREAK);
                        return;
                    }
                }
                if ((object = literal.getValue()) instanceof Character && (((Character)(value = (Character)object)).charValue() == '\n' || ((Character)value).charValue() == '\r')) {
                    SystemSpecificLineBreak.this.addLocalProblem(literal, new LocalizedMessage("system-specific-linebreak"), ProblemType.SYSTEM_SPECIFIC_LINE_BREAK);
                }
            }
        });
    }

    @Override
    public Optional<Integer> maximumProblems() {
        return Optional.of(3);
    }
}

