/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.general;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.dynamic.DynamicAnalysis;
import de.firemage.autograder.core.integrated.ForLoopRange;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import spoon.processing.AbstractProcessor;
import spoon.reflect.code.CtArrayRead;
import spoon.reflect.code.CtBodyHolder;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldRead;
import spoon.reflect.code.CtFor;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.reference.CtArrayTypeReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.reference.CtVariableReference;

@ExecutableCheck(reportedProblems={ProblemType.FOR_CAN_BE_FOREACH})
public class ForToForEachLoop
extends IntegratedCheck {
    private static final Function<CtVariableAccess<?>, Optional<CtVariableAccess<?>>> LOOP_VARIABLE_ACCESS_STRING = ctVariableAccess -> {
        CtExpression patt1731$temp;
        CtInvocation ctInvocation;
        CtElement patt1544$temp = ctVariableAccess.getParent();
        if (patt1544$temp instanceof CtInvocation && SpoonUtil.isSignatureEqualTo((ctInvocation = (CtInvocation)patt1544$temp).getExecutable(), Character.TYPE, "charAt", Integer.TYPE) && (patt1731$temp = ctInvocation.getTarget()) instanceof CtVariableAccess) {
            CtVariableAccess variableAccess = (CtVariableAccess)patt1731$temp;
            return Optional.of(variableAccess);
        }
        return Optional.empty();
    };
    private static final Function<CtVariableAccess<?>, Optional<CtVariableAccess<?>>> LOOP_VARIABLE_ACCESS_ARRAY = ctVariableAccess -> {
        CtArrayRead arrayAccess;
        CtExpression patt2135$temp;
        CtElement patt2058$temp = ctVariableAccess.getParent();
        if (patt2058$temp instanceof CtArrayRead && (patt2135$temp = (arrayAccess = (CtArrayRead)patt2058$temp).getTarget()) instanceof CtVariableAccess) {
            CtVariableAccess variableAccess = (CtVariableAccess)patt2135$temp;
            return Optional.of(variableAccess);
        }
        return Optional.empty();
    };
    public static final Function<CtVariableAccess<?>, Optional<CtVariableAccess<?>>> LOOP_VARIABLE_ACCESS_LIST = ctVariableAccess -> {
        CtVariableAccess variableAccess;
        CtExpression patt2723$temp;
        CtInvocation ctInvocation;
        CtElement patt2460$temp = ctVariableAccess.getParent();
        if (patt2460$temp instanceof CtInvocation && (ctInvocation = (CtInvocation)patt2460$temp).getExecutable().getSimpleName().equals("get") && (patt2723$temp = ctInvocation.getTarget()) instanceof CtVariableAccess && SpoonUtil.isSubtypeOf((variableAccess = (CtVariableAccess)patt2723$temp).getType(), List.class)) {
            return Optional.of(variableAccess);
        }
        return Optional.empty();
    };

    public static Optional<CtVariable<?>> getForEachLoopVariable(CtBodyHolder ctBodyHolder, ForLoopRange forLoopRange, Function<CtVariableAccess<?>, Optional<CtVariableAccess<?>>> getPotentialLoopVariableAccess) {
        CtLocalVariable loopVariable = forLoopRange.loopVariable().getDeclaration();
        CtVariable ctVariable = null;
        CtVariableAccess expectedAccess = null;
        for (CtElement use : SpoonUtil.findUsesIn((CtElement)loopVariable, (CtElement)ctBodyHolder.getBody())) {
            if (!(use instanceof CtVariableAccess)) {
                throw new IllegalStateException("SpoonUtil.findUsesIn returned non-variable access for '%s' as input".formatted(loopVariable));
            }
            CtVariableAccess ctVariableAccess = (CtVariableAccess)use;
            CtVariableAccess potentialLoopVariableAccess = getPotentialLoopVariableAccess.apply(ctVariableAccess).orElse(null);
            if (!(potentialLoopVariableAccess instanceof CtVariableRead)) {
                return Optional.empty();
            }
            if (expectedAccess == null) {
                expectedAccess = potentialLoopVariableAccess;
            }
            if (!expectedAccess.equals(potentialLoopVariableAccess)) {
                return Optional.empty();
            }
            CtVariableReference potentialVariable = potentialLoopVariableAccess.getVariable();
            if (potentialVariable.getDeclaration() == null) {
                return Optional.empty();
            }
            if (ctVariable == null) {
                ctVariable = potentialVariable.getDeclaration();
            }
            if (ctVariable.equals(potentialVariable.getDeclaration())) continue;
            return Optional.empty();
        }
        return Optional.ofNullable(ctVariable);
    }

    public static Optional<CtVariable<?>> findIterable(ForLoopRange forLoopRange) {
        CtInvocation ctInvocation;
        CtVariableAccess target;
        CtExpression ctExpression;
        CtFieldRead ctFieldRead;
        CtExpression<Integer> end = forLoopRange.end();
        if (end instanceof CtFieldRead && (ctFieldRead = (CtFieldRead)end).getVariable().getSimpleName().equals("length") && (ctExpression = ctFieldRead.getTarget()) instanceof CtVariableAccess && (target = (CtVariableAccess)ctExpression).getType().isArray()) {
            return Optional.ofNullable(target.getVariable().getDeclaration());
        }
        if (end instanceof CtInvocation && SpoonUtil.isSignatureEqualTo((ctInvocation = (CtInvocation)end).getExecutable(), Integer.TYPE, "size", new Class[0]) && (ctExpression = ctInvocation.getTarget()) instanceof CtVariableAccess && SpoonUtil.isSubtypeOf((target = (CtVariableAccess)ctExpression).getType(), Collection.class)) {
            return Optional.ofNullable(target.getVariable().getDeclaration());
        }
        if (end instanceof CtInvocation && SpoonUtil.isSignatureEqualTo((ctInvocation = (CtInvocation)end).getExecutable(), Integer.TYPE, "length", new Class[0]) && (ctExpression = ctInvocation.getTarget()) instanceof CtVariableAccess && SpoonUtil.isTypeEqualTo((target = (CtVariableAccess)ctExpression).getType(), String.class)) {
            return Optional.ofNullable(target.getVariable().getDeclaration());
        }
        return Optional.empty();
    }

    @Override
    protected void check(StaticAnalysis staticAnalysis, DynamicAnalysis dynamicAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtFor>(){

            public void process(CtFor ctFor) {
                Function<CtVariableAccess<?>, Optional<CtVariableAccess<?>>> getPotentialLoopVariableAccess;
                CtLiteral ctLiteral;
                if (ctFor.isImplicit() || !ctFor.getPosition().isValidPosition()) {
                    return;
                }
                ForLoopRange forLoopRange = ForLoopRange.fromCtFor(ctFor).orElse(null);
                if (forLoopRange == null) {
                    return;
                }
                CtExpression<Integer> ctExpression = forLoopRange.start();
                if (!(ctExpression instanceof CtLiteral) || (Integer)(ctLiteral = (CtLiteral)ctExpression).getValue() != 0) {
                    return;
                }
                CtVariable iterable = ForToForEachLoop.findIterable(forLoopRange).orElse(null);
                if (iterable == null) {
                    return;
                }
                CtTypeReference elementType = ctFor.getFactory().createCtTypeReference(Object.class);
                String iterableExpression = iterable.getSimpleName();
                if (SpoonUtil.isString(iterable.getType())) {
                    getPotentialLoopVariableAccess = LOOP_VARIABLE_ACCESS_STRING;
                    iterableExpression = "%s.toCharArray()".formatted(iterableExpression);
                    elementType = ctFor.getFactory().createCtTypeReference(Character.TYPE);
                } else if (SpoonUtil.isSubtypeOf(iterable.getType(), List.class)) {
                    getPotentialLoopVariableAccess = LOOP_VARIABLE_ACCESS_LIST;
                    if (iterable.getType().getActualTypeArguments().size() == 1) {
                        elementType = ((CtTypeReference)iterable.getType().getActualTypeArguments().get(0)).unbox();
                    }
                } else {
                    CtTypeReference ctTypeReference = iterable.getType();
                    if (ctTypeReference instanceof CtArrayTypeReference) {
                        CtArrayTypeReference arrayTypeReference = (CtArrayTypeReference)ctTypeReference;
                        getPotentialLoopVariableAccess = LOOP_VARIABLE_ACCESS_ARRAY;
                        elementType = arrayTypeReference.getComponentType();
                    } else {
                        return;
                    }
                }
                CtVariable ctLoopVariable = ForToForEachLoop.getForEachLoopVariable((CtBodyHolder)ctFor, forLoopRange, getPotentialLoopVariableAccess).orElse(null);
                if (!iterable.equals(ctLoopVariable)) {
                    return;
                }
                ForToForEachLoop.this.addLocalProblem((CtElement)ctFor, new LocalizedMessage("common-reimplementation", Map.of("suggestion", "for (%s value : %s) { ... }".formatted(elementType.prettyprint(), iterableExpression))), ProblemType.FOR_CAN_BE_FOREACH);
            }
        });
    }
}

