/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.general;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.dynamic.DynamicAnalysis;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import java.util.Map;
import java.util.Optional;
import spoon.processing.AbstractProcessor;
import spoon.reflect.code.CtFieldWrite;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtField;

@ExecutableCheck(reportedProblems={ProblemType.FIELD_SHOULD_BE_FINAL})
public class FieldShouldBeFinal
extends IntegratedCheck {
    @Override
    protected void check(StaticAnalysis staticAnalysis, DynamicAnalysis dynamicAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtField<?>>(){

            public void process(CtField<?> ctField) {
                boolean hasExplicitValue;
                if (ctField.isImplicit() || !ctField.getPosition().isValidPosition() || ctField.isFinal()) {
                    return;
                }
                boolean hasWrite = SpoonUtil.hasAnyUses(ctField, ctElement -> {
                    CtFieldWrite ctFieldWrite;
                    return ctElement instanceof CtFieldWrite && (ctFieldWrite = (CtFieldWrite)ctElement).getParent(CtConstructor.class) == null;
                });
                if (hasWrite) {
                    return;
                }
                boolean hasWriteInConstructor = SpoonUtil.hasAnyUses(ctField, ctElement -> {
                    CtFieldWrite ctFieldWrite;
                    return ctElement instanceof CtFieldWrite && (ctFieldWrite = (CtFieldWrite)ctElement).getParent(CtConstructor.class) != null;
                });
                boolean bl = hasExplicitValue = ctField.getDefaultExpression() != null && !ctField.getDefaultExpression().isImplicit();
                if (ctField.isStatic() && (hasWriteInConstructor || !hasExplicitValue)) {
                    return;
                }
                if (!hasWriteInConstructor || !hasExplicitValue) {
                    FieldShouldBeFinal.this.addLocalProblem(ctField, new LocalizedMessage("field-should-be-final", Map.of("name", ctField.getSimpleName())), ProblemType.FIELD_SHOULD_BE_FINAL);
                }
            }
        });
    }

    @Override
    public Optional<Integer> maximumProblems() {
        return Optional.of(4);
    }
}

