/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.general;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.dynamic.DynamicAnalysis;
import de.firemage.autograder.core.integrated.IdentifierNameUtils;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import java.util.Map;
import java.util.Set;
import spoon.processing.AbstractProcessor;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtModifiable;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.reference.CtTypeReference;

@ExecutableCheck(reportedProblems={ProblemType.FIELD_SHOULD_BE_CONSTANT, ProblemType.LOCAL_VARIABLE_SHOULD_BE_CONSTANT})
public class ConstantNamingAndQualifierCheck
extends IntegratedCheck {
    private static final Set<String> IGNORE_FIELDS = Set.of("serialVersionUID");

    private static String getVisibilityString(CtModifiable ctModifiable) {
        ModifierKind modifierKind = ctModifiable.getVisibility();
        if (ctModifiable instanceof CtLocalVariable) {
            return "private ";
        }
        if (modifierKind == null) {
            return "";
        }
        return modifierKind + " ";
    }

    private static String makeSuggestion(CtVariable<?> ctVariable) {
        CtTypeReference ctVariableType = ctVariable.getType();
        return "%sstatic final %s %s = %s".formatted(ConstantNamingAndQualifierCheck.getVisibilityString(ctVariable), ctVariableType.getSimpleName(), IdentifierNameUtils.toUpperSnakeCase(ctVariable.getSimpleName()), ctVariable.getDefaultExpression().prettyprint());
    }

    @Override
    protected void check(StaticAnalysis staticAnalysis, DynamicAnalysis dynamicAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtVariable<?>>(){

            public void process(CtVariable<?> ctVariable) {
                CtField ctField;
                CtLocalVariable ctLocalVariable;
                if (ctVariable.isImplicit() || !ctVariable.getPosition().isValidPosition() || !SpoonUtil.isEffectivelyFinal(ctVariable) || ctVariable.getDefaultExpression() == null || IGNORE_FIELDS.contains(ctVariable.getSimpleName())) {
                    return;
                }
                if (!ctVariable.getType().unbox().isPrimitive() && !SpoonUtil.isString(ctVariable.getType())) {
                    return;
                }
                if (ctVariable instanceof CtLocalVariable && SpoonUtil.resolveCtExpression((ctLocalVariable = (CtLocalVariable)ctVariable).getDefaultExpression()) instanceof CtLiteral) {
                    ConstantNamingAndQualifierCheck.this.addLocalProblem((CtElement)ctLocalVariable, new LocalizedMessage("variable-should-be", Map.of("variable", ctLocalVariable.getSimpleName(), "suggestion", ConstantNamingAndQualifierCheck.makeSuggestion(ctLocalVariable))), ProblemType.LOCAL_VARIABLE_SHOULD_BE_CONSTANT);
                    return;
                }
                if (!(!(ctVariable instanceof CtField) || (ctField = (CtField)ctVariable).isStatic() && IdentifierNameUtils.isUpperSnakeCase(ctField.getSimpleName()))) {
                    ConstantNamingAndQualifierCheck.this.addLocalProblem((CtElement)ctField, new LocalizedMessage("variable-should-be", Map.of("variable", ctField.getSimpleName(), "suggestion", ConstantNamingAndQualifierCheck.makeSuggestion(ctField))), ProblemType.FIELD_SHOULD_BE_CONSTANT);
                }
            }
        });
    }
}

