/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.general;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.dynamic.DynamicAnalysis;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import spoon.processing.AbstractProcessor;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypeInformation;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtTypeReference;

@ExecutableCheck(reportedProblems={ProblemType.AVOID_SHADOWING})
public class AvoidShadowing
extends IntegratedCheck {
    private static final List<String> ALLOWED_FIELDS = List.of("serialVersionUID");

    private static Collection<CtFieldReference<?>> getAllVisibleFields(CtTypeInformation ctTypeInformation) {
        ArrayList result = new ArrayList(ctTypeInformation.getDeclaredFields());
        for (CtTypeReference parent = ctTypeInformation.getSuperclass(); parent != null; parent = parent.getSuperclass()) {
            result.addAll(parent.getDeclaredFields().stream().filter(ctFieldReference -> !ctFieldReference.getFieldDeclaration().isPrivate()).toList());
        }
        return result;
    }

    private static <T> boolean hasVariableReadIn(CtVariable<T> ctVariable, CtElement in) {
        return SpoonUtil.findUsesIn(ctVariable, in).stream().anyMatch(ctElement -> ctElement instanceof CtVariableRead);
    }

    @Override
    protected void check(StaticAnalysis staticAnalysis, DynamicAnalysis dynamicAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtVariable<?>>(){

            public void process(CtVariable<?> ctVariable) {
                if (ctVariable.getParent(CtConstructor.class) != null) {
                    return;
                }
                if (SpoonUtil.isInOverriddenMethod(ctVariable) || SpoonUtil.isInSetter(ctVariable)) {
                    return;
                }
                CtMethod ctMethod = (CtMethod)ctVariable.getParent(CtMethod.class);
                if (ctMethod != null && ctMethod.isStatic()) {
                    return;
                }
                CtType parent = (CtType)ctVariable.getParent(CtType.class);
                if (parent == null || ctVariable.getReference() == null) {
                    return;
                }
                Collection<CtFieldReference<?>> visibleFields = AvoidShadowing.getAllVisibleFields((CtTypeInformation)parent);
                List<CtFieldReference> hiddenFields = visibleFields.stream().filter(ctFieldReference -> !ALLOWED_FIELDS.contains(ctFieldReference.getSimpleName())).filter(ctFieldReference -> ctFieldReference.getSimpleName().equals(ctVariable.getSimpleName()) && !ctFieldReference.equals(ctVariable.getReference())).toList();
                if (hiddenFields.isEmpty()) {
                    return;
                }
                CtElement variableParent = ctVariable.getParent();
                boolean isFieldRead = hiddenFields.stream().anyMatch(ctFieldReference -> AvoidShadowing.hasVariableReadIn(ctFieldReference.getFieldDeclaration(), variableParent));
                if (AvoidShadowing.hasVariableReadIn(ctVariable, variableParent) && isFieldRead) {
                    AvoidShadowing.this.addLocalProblem(ctVariable, new LocalizedMessage("avoid-shadowing", Map.of("name", ctVariable.getSimpleName())), ProblemType.AVOID_SHADOWING);
                }
            }
        });
    }
}

