/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.exceptions;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.dynamic.DynamicAnalysis;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import java.util.Map;
import spoon.processing.AbstractProcessor;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.reference.CtTypeReference;

@ExecutableCheck(reportedProblems={ProblemType.CUSTOM_EXCEPTION_INHERITS_RUNTIME_EXCEPTION, ProblemType.CUSTOM_EXCEPTION_INHERITS_ERROR})
public class CustomExceptionInheritanceCheck
extends IntegratedCheck {
    @Override
    protected void check(StaticAnalysis staticAnalysis, DynamicAnalysis dynamicAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtClass<?>>(){

            public void process(CtClass<?> ctClass) {
                CtTypeReference error;
                if (ctClass.isImplicit() || !ctClass.getPosition().isValidPosition()) {
                    return;
                }
                CtTypeReference runtimeException = ctClass.getFactory().Type().createReference(RuntimeException.class);
                if (ctClass.isSubtypeOf(runtimeException)) {
                    CustomExceptionInheritanceCheck.this.addLocalProblem(ctClass, new LocalizedMessage("custom-exception-inheritance-runtime", Map.of("name", ctClass.getSimpleName())), ProblemType.CUSTOM_EXCEPTION_INHERITS_RUNTIME_EXCEPTION);
                }
                if (ctClass.isSubtypeOf(error = ctClass.getFactory().Type().createReference(Error.class))) {
                    CustomExceptionInheritanceCheck.this.addLocalProblem(ctClass, new LocalizedMessage("custom-exception-inheritance-error", Map.of("name", ctClass.getSimpleName())), ProblemType.CUSTOM_EXCEPTION_INHERITS_ERROR);
                }
            }
        });
    }
}

