/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.complexity;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.dynamic.DynamicAnalysis;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtCase;
import spoon.reflect.code.CtDo;
import spoon.reflect.code.CtFor;
import spoon.reflect.code.CtForEach;
import spoon.reflect.code.CtIf;
import spoon.reflect.code.CtLambda;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtTry;
import spoon.reflect.code.CtWhile;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.visitor.CtScanner;
import spoon.reflect.visitor.CtVisitor;

@ExecutableCheck(reportedProblems={ProblemType.TRY_CATCH_COMPLEXITY})
public class TryCatchComplexity
extends IntegratedCheck {
    public static final int MAX_ALLOWED_STATEMENTS = 15;
    public static final String LOCALIZED_MESSAGE_KEY = "try-catch-complexity";

    @Override
    public void check(StaticAnalysis staticAnalysis, DynamicAnalysis dynamicAnalysis) {
        staticAnalysis.getModel().getRootPackage().accept((CtVisitor)new CtScanner(){

            public void visitCtTry(CtTry ctTry) {
                ArrayList<CtStatement> statements = new ArrayList<CtStatement>();
                TryCatchComplexity.this.visitNestedStatement(ctTry, statements);
                if (statements.size() > 15) {
                    TryCatchComplexity.this.addLocalProblem((CtElement)ctTry, new LocalizedMessage(TryCatchComplexity.LOCALIZED_MESSAGE_KEY, Map.of("max", 15)), ProblemType.TRY_CATCH_COMPLEXITY);
                }
            }
        });
    }

    private void visitNestedStatement(CtTry ctTry, List<CtStatement> allStatements) {
        List<CtStatement> stats = this.filterMethodInvocations(ctTry.getBody().getStatements());
        stats.forEach(statement -> this.visitStatement((CtStatement)statement, allStatements));
        allStatements.addAll(this.extractMethodInvocations(ctTry.getBody().getStatements()));
    }

    private List<CtStatement> filterMethodInvocations(List<CtStatement> statements) {
        return statements.stream().filter(statement -> !SpoonUtil.isInvocation(statement)).toList();
    }

    private List<CtStatement> extractMethodInvocations(List<CtStatement> statements) {
        return statements.stream().filter(SpoonUtil::isInvocation).toList();
    }

    private void visitStatement(CtStatement statement, final List<CtStatement> allStatements) {
        if (statement == null || allStatements.size() > 15) {
            return;
        }
        if (!(statement instanceof CtBlock)) {
            allStatements.add(statement);
        }
        statement.accept((CtVisitor)new CtScanner(){

            public void visitCtTry(CtTry ctTry) {
                TryCatchComplexity.this.visitNestedStatement(ctTry, allStatements);
                List catchers = ctTry.getCatchers();
                catchers.stream().flatMap(catcher -> catcher.getBody().getStatements().stream()).filter(statement -> !SpoonUtil.isInvocation(statement)).forEach(statement -> TryCatchComplexity.this.visitStatement((CtStatement)statement, allStatements));
                allStatements.addAll(TryCatchComplexity.this.extractMethodInvocations(catchers.stream().flatMap(catcher -> catcher.getBody().getStatements().stream()).toList()));
            }

            public void visitCtIf(CtIf ctIf) {
                TryCatchComplexity.this.visitStatement(ctIf.getThenStatement(), allStatements);
                TryCatchComplexity.this.visitStatement(ctIf.getElseStatement(), allStatements);
            }

            public <R> void visitCtBlock(CtBlock<R> block) {
                List blockStatements = block.getStatements();
                TryCatchComplexity.this.filterMethodInvocations(blockStatements).forEach(statement -> TryCatchComplexity.this.visitStatement((CtStatement)statement, allStatements));
                allStatements.addAll(TryCatchComplexity.this.extractMethodInvocations(blockStatements));
            }

            public void visitCtDo(CtDo doLoop) {
                TryCatchComplexity.this.visitStatement(doLoop.getBody(), allStatements);
            }

            public void visitCtCase(CtCase ctCase) {
                allStatements.add(ctCase);
                TryCatchComplexity.this.filterMethodInvocations(ctCase.getStatements()).forEach(statement -> TryCatchComplexity.this.visitStatement((CtStatement)statement, allStatements));
                allStatements.addAll(TryCatchComplexity.this.extractMethodInvocations(ctCase.getStatements()));
            }

            public void visitCtFor(CtFor forLoop) {
                TryCatchComplexity.this.visitStatement(forLoop.getBody(), allStatements);
            }

            public void visitCtForEach(CtForEach foreach) {
                TryCatchComplexity.this.visitStatement(foreach.getBody(), allStatements);
            }

            public void visitCtWhile(CtWhile whileLoop) {
                TryCatchComplexity.this.visitStatement(whileLoop.getBody(), allStatements);
            }

            public void visitCtLambda(CtLambda lambda) {
                allStatements.add(lambda.getBody());
            }
        });
    }
}

