/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.complexity;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.dynamic.DynamicAnalysis;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import de.firemage.autograder.core.integrated.evaluator.Evaluator;
import de.firemage.autograder.core.integrated.evaluator.fold.Fold;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import spoon.processing.AbstractProcessor;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldRead;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.factory.TypeFactory;
import spoon.reflect.reference.CtVariableReference;

@ExecutableCheck(reportedProblems={ProblemType.REPEATED_MATH_OPERATION})
public class RepeatedMathOperationCheck
extends IntegratedCheck {
    private static final Map<BinaryOperatorKind, Integer> OCCURRENCE_THRESHOLDS = Map.of(BinaryOperatorKind.PLUS, 2, BinaryOperatorKind.MUL, 3);

    private static List<CtExpression<?>> splitOperator(CtBinaryOperator<?> ctBinaryOperator, BinaryOperatorKind kind) {
        CtBinaryOperator lhs;
        ArrayList result = new ArrayList();
        if (ctBinaryOperator.getKind() != kind) {
            return new ArrayList(List.of(ctBinaryOperator));
        }
        CtExpression left = ctBinaryOperator.getLeftHandOperand();
        CtExpression right = ctBinaryOperator.getRightHandOperand();
        if (right instanceof CtBinaryOperator) {
            CtBinaryOperator rightOperator = (CtBinaryOperator)right;
            List<CtExpression<?>> rightOperands = RepeatedMathOperationCheck.splitOperator(rightOperator, kind);
            Collections.reverse(rightOperands);
            result.addAll(rightOperands);
        } else {
            result.add(right);
        }
        while (left instanceof CtBinaryOperator && (lhs = (CtBinaryOperator)left).getKind() == kind) {
            result.add(lhs.getRightHandOperand());
            left = lhs.getLeftHandOperand();
        }
        result.add(left);
        Collections.reverse(result);
        return result;
    }

    public static CtExpression<?> repeatExpression(BinaryOperatorKind kind, CtExpression<?> expression, int count) {
        Object[] array = new CtExpression[count - 1];
        Arrays.fill(array, expression);
        return RepeatedMathOperationCheck.joinExpressions(kind, expression, array);
    }

    public static CtExpression<?> joinExpressions(BinaryOperatorKind kind, CtExpression<?> first, CtExpression<?> ... others) {
        return Arrays.stream(others).reduce(first, (left, right) -> SpoonUtil.createBinaryOperator(left, right, kind));
    }

    @Override
    protected void check(StaticAnalysis staticAnalysis, DynamicAnalysis dynamicAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtExpression<?>>(){

            public void process(CtExpression<?> ctExpression) {
                if (ctExpression.isImplicit() || !ctExpression.getPosition().isValidPosition() || ctExpression.getParent(CtExpression.class) != null) {
                    return;
                }
                AtomicInteger plusOptimizations = new AtomicInteger();
                AtomicInteger mulOptimizations = new AtomicInteger();
                OperatorFolder plusFolder = new OperatorFolder(BinaryOperatorKind.PLUS, OCCURRENCE_THRESHOLDS.get(BinaryOperatorKind.PLUS), (expression, count) -> {
                    plusOptimizations.addAndGet(1);
                    return SpoonUtil.createBinaryOperator(expression, SpoonUtil.makeLiteralNumber(expression.getType(), count), BinaryOperatorKind.MUL);
                });
                OperatorFolder mulFolder = new OperatorFolder(BinaryOperatorKind.MUL, OCCURRENCE_THRESHOLDS.get(BinaryOperatorKind.MUL), (expression, count) -> {
                    TypeFactory typeFactory = expression.getFactory().Type();
                    mulOptimizations.addAndGet(1);
                    return SpoonUtil.createStaticInvocation(typeFactory.get(Math.class).getReference(), "pow", new CtExpression[]{expression, SpoonUtil.makeLiteralNumber(typeFactory.integerPrimitiveType(), count)});
                });
                CtExpression<?> suggestion = new Evaluator(plusFolder).evaluate(ctExpression);
                suggestion = new Evaluator(mulFolder).evaluate(suggestion);
                if (plusOptimizations.get() > 0 || mulOptimizations.get() > 0) {
                    RepeatedMathOperationCheck.this.addLocalProblem(ctExpression, new LocalizedMessage("common-reimplementation", Map.of("suggestion", suggestion)), ProblemType.REPEATED_MATH_OPERATION);
                }
            }
        });
    }

    private Map<Variable, Integer> countOccurrences(CtExpression<?> expression, BinaryOperatorKind kind) {
        CtBinaryOperator operator;
        if (expression instanceof CtFieldRead) {
            CtFieldRead read = (CtFieldRead)expression;
            return Map.of(new Variable((CtVariableReference<?>)read.getVariable(), (CtExpression<?>)read.getTarget()), 1);
        }
        if (expression instanceof CtVariableRead) {
            CtVariableRead read = (CtVariableRead)expression;
            return Map.of(new Variable(read.getVariable(), null), 1);
        }
        if (expression instanceof CtBinaryOperator && (operator = (CtBinaryOperator)expression).getKind() == kind) {
            if (SpoonUtil.isString(operator.getLeftHandOperand().getType()) || SpoonUtil.isString(operator.getRightHandOperand().getType())) {
                return Map.of();
            }
            return this.mergeMaps(this.countOccurrences(operator.getLeftHandOperand(), kind), this.countOccurrences(operator.getRightHandOperand(), kind));
        }
        return Map.of();
    }

    private <K> Map<K, Integer> mergeMaps(Map<? extends K, Integer> left, Map<? extends K, Integer> right) {
        return Stream.concat(left.entrySet().stream(), right.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, Integer::sum));
    }

    private record Variable(CtVariableReference<?> ctVariableReference, CtExpression<?> target) {
    }

    private record OperatorFolder(BinaryOperatorKind kind, int threshold, BiFunction<CtExpression<?>, Integer, CtExpression<?>> function) implements Fold
    {
        @Override
        public CtElement enter(CtElement ctElement) {
            return this.fold(ctElement);
        }

        @Override
        public CtElement exit(CtElement ctElement) {
            return ctElement;
        }

        @Override
        public <T> CtExpression<T> foldCtBinaryOperator(CtBinaryOperator<T> ctBinaryOperator) {
            if (!OCCURRENCE_THRESHOLDS.containsKey(ctBinaryOperator.getKind()) || !SpoonUtil.isPrimitiveNumeric(ctBinaryOperator.getType())) {
                return ctBinaryOperator;
            }
            List<CtExpression<?>> operands = RepeatedMathOperationCheck.splitOperator(ctBinaryOperator, this.kind);
            Map occurrences = operands.stream().collect(Collectors.toMap(o -> o, o -> 1, Integer::sum, LinkedHashMap::new));
            return occurrences.entrySet().stream().map(entry -> {
                CtExpression expression = (CtExpression)entry.getKey();
                int count = (Integer)entry.getValue();
                if (count < this.threshold) {
                    return RepeatedMathOperationCheck.repeatExpression(this.kind, expression, count);
                }
                return this.function.apply(expression, count);
            }).reduce((left, right) -> SpoonUtil.createBinaryOperator(left, right, this.kind)).orElseThrow();
        }
    }
}

