/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.complexity;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.dynamic.DynamicAnalysis;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import spoon.processing.AbstractProcessor;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtVariableWrite;

@ExecutableCheck(reportedProblems={ProblemType.REDUNDANT_UNINITIALIZED_VARIABLE})
public class RedundantUninitializedVariable
extends IntegratedCheck {
    private static String makeSuggestion(CtLocalVariable<?> ctLocalVariable, CtExpression<?> ctValue) {
        String modifier = ctLocalVariable.getModifiers().stream().map(Object::toString).map(string -> string + " ").collect(Collectors.joining(""));
        return "%s%s %s = %s".formatted(modifier, ctLocalVariable.getType().prettyprint(), ctLocalVariable.getSimpleName(), ctValue);
    }

    @Override
    protected void check(StaticAnalysis staticAnalysis, DynamicAnalysis dynamicAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtLocalVariable<?>>(){

            public void process(CtLocalVariable<?> ctLocalVariable) {
                boolean isConditional;
                if (!ctLocalVariable.getPosition().isValidPosition() || ctLocalVariable.getAssignment() != null) {
                    return;
                }
                List ctAssignments = ctLocalVariable.getParent().getElements(ctAssignment -> {
                    CtVariableWrite ctVariableWrite;
                    CtExpression patt2274$temp = ctAssignment.getAssigned();
                    return patt2274$temp instanceof CtVariableWrite && (ctVariableWrite = (CtVariableWrite)patt2274$temp).getVariable().equals(ctLocalVariable.getReference());
                });
                if (ctAssignments.isEmpty()) {
                    return;
                }
                boolean bl = isConditional = !SpoonUtil.getEffectiveStatements((CtStatement)ctLocalVariable.getParent(CtBlock.class)).contains(ctAssignments.get(0));
                if (isConditional) {
                    return;
                }
                CtExpression ctValue = ((CtAssignment)ctAssignments.get(0)).getAssignment();
                RedundantUninitializedVariable.this.addLocalProblem(ctLocalVariable, new LocalizedMessage("redundant-uninitialized-variable", Map.of("variable", ctLocalVariable.getSimpleName(), "value", ctValue.prettyprint(), "suggestion", RedundantUninitializedVariable.makeSuggestion(ctLocalVariable, ctValue))), ProblemType.REDUNDANT_UNINITIALIZED_VARIABLE);
            }
        });
    }
}

