/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.complexity;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.dynamic.DynamicAnalysis;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import de.firemage.autograder.core.integrated.evaluator.Evaluator;
import de.firemage.autograder.core.integrated.evaluator.fold.Fold;
import java.util.Map;
import spoon.processing.AbstractProcessor;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtUnaryOperator;
import spoon.reflect.code.UnaryOperatorKind;

@ExecutableCheck(reportedProblems={ProblemType.REDUNDANT_NEGATION})
public class RedundantNegationCheck
extends IntegratedCheck {
    @Override
    protected void check(StaticAnalysis staticAnalysis, DynamicAnalysis dynamicAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtExpression<?>>(){

            public void process(CtExpression<?> ctExpression) {
                if (ctExpression.isImplicit() || !ctExpression.getPosition().isValidPosition() || ctExpression.getParent(CtExpression.class) != null) {
                    return;
                }
                CtExpression<?> negated = new Evaluator(new NegationFolder()).evaluate(ctExpression);
                if (ctExpression.equals(negated)) {
                    return;
                }
                RedundantNegationCheck.this.addLocalProblem(ctExpression, new LocalizedMessage("common-reimplementation", Map.of("suggestion", negated.prettyprint())), ProblemType.REDUNDANT_NEGATION);
            }
        });
    }

    private record NegationFolder() implements Fold
    {
        @Override
        public <T> CtExpression<T> foldCtUnaryOperator(CtUnaryOperator<T> ctUnaryOperator) {
            if (ctUnaryOperator.getKind() != UnaryOperatorKind.NOT) {
                return ctUnaryOperator;
            }
            CtExpression operand = ctUnaryOperator.getOperand();
            return SpoonUtil.negate(operand);
        }
    }
}

