/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.complexity;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.check.unnecessary.UnusedCodeElementCheck;
import de.firemage.autograder.core.dynamic.DynamicAnalysis;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import java.util.List;
import java.util.Map;
import spoon.processing.AbstractProcessor;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtStatementList;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.code.CtVariableWrite;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtNamedElement;
import spoon.reflect.reference.CtLocalVariableReference;

@ExecutableCheck(reportedProblems={ProblemType.REDUNDANT_ASSIGNMENT})
public class RedundantAssignment
extends IntegratedCheck {
    @Override
    protected void check(StaticAnalysis staticAnalysis, DynamicAnalysis dynamicAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtAssignment<?, ?>>(){

            public void process(CtAssignment<?, ?> ctAssignment) {
                CtVariableWrite ctVariableWrite;
                CtExpression ctExpression;
                if (ctAssignment.isImplicit() || !ctAssignment.getPosition().isValidPosition() || !((ctExpression = ctAssignment.getAssigned()) instanceof CtVariableWrite) || !((ctExpression = (ctVariableWrite = (CtVariableWrite)ctExpression).getVariable()) instanceof CtLocalVariableReference)) {
                    return;
                }
                CtLocalVariableReference ctLocalVariableReference = (CtLocalVariableReference)ctExpression;
                if (!(ctAssignment.getParent() instanceof CtStatementList) || ctLocalVariableReference.getDeclaration() == null || !(ctAssignment.getParent().getParent() instanceof CtMethod)) {
                    return;
                }
                List<CtStatement> followingStatements = SpoonUtil.getNextStatements(ctAssignment);
                CtLocalVariable ctLocalVariable = ctLocalVariableReference.getDeclaration();
                if (UnusedCodeElementCheck.isUnused((CtNamedElement)ctLocalVariable, true)) {
                    return;
                }
                if (followingStatements.stream().noneMatch(statement -> SpoonUtil.hasAnyUsesIn((CtElement)ctLocalVariable, (CtElement)statement, element -> element instanceof CtVariableRead))) {
                    RedundantAssignment.this.addLocalProblem(ctAssignment, new LocalizedMessage("redundant-assignment", Map.of("variable", ctLocalVariable.getSimpleName())), ProblemType.REDUNDANT_ASSIGNMENT);
                }
            }
        });
    }
}

