/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.complexity;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.dynamic.DynamicAnalysis;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import spoon.processing.AbstractProcessor;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.reference.CtTypeReference;

@ExecutableCheck(reportedProblems={ProblemType.EXPLICITLY_EXTENDS_OBJECT})
public class ExtendsObjectCheck
extends IntegratedCheck {
    @Override
    protected void check(StaticAnalysis staticAnalysis, DynamicAnalysis dynamicAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtClass<?>>(){

            public void process(CtClass<?> ctClass) {
                CtTypeReference ctTypeReference = ctClass.getSuperclass();
                if (ctTypeReference == null || ctTypeReference.isImplicit() || !ctTypeReference.getPosition().isValidPosition()) {
                    return;
                }
                if (ctClass.getFactory().Type().createReference(Object.class).equals(ctTypeReference)) {
                    ExtendsObjectCheck.this.addLocalProblem((CtElement)ctTypeReference, new LocalizedMessage("extends-object"), ProblemType.EXPLICITLY_EXTENDS_OBJECT);
                }
            }
        });
    }
}

