/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.comment;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.dynamic.DynamicAnalysis;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import java.util.Map;
import spoon.processing.AbstractProcessor;
import spoon.reflect.code.CtJavaDoc;
import spoon.reflect.code.CtJavaDocTag;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtMethod;

@ExecutableCheck(reportedProblems={ProblemType.JAVADOC_STUB_DESCRIPTION, ProblemType.JAVADOC_STUB_RETURN_TAG, ProblemType.JAVADOC_STUB_THROWS_TAG, ProblemType.JAVADOC_STUB_PARAMETER_TAG})
public class JavadocStubCheck
extends IntegratedCheck {
    private final boolean allowGettersSettersWithEmptyDescription;

    public JavadocStubCheck(boolean allowGettersSettersWithEmptyDescription) {
        this.allowGettersSettersWithEmptyDescription = allowGettersSettersWithEmptyDescription;
    }

    public JavadocStubCheck() {
        this(true);
    }

    @Override
    protected void check(StaticAnalysis staticAnalysis, DynamicAnalysis dynamicAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtJavaDoc>(){

            public void process(CtJavaDoc javadoc) {
                CtMethod method;
                CtElement ctElement;
                if (!(JavadocStubCheck.this.allowGettersSettersWithEmptyDescription && (ctElement = javadoc.getParent()) instanceof CtMethod && (SpoonUtil.isGetter(method = (CtMethod)ctElement) || SpoonUtil.isSetter(method)) || !JavadocStubCheck.this.isDefaultValueDescription(javadoc.getContent()))) {
                    JavadocStubCheck.this.addLocalProblem((CtElement)javadoc, new LocalizedMessage("javadoc-stub-exp-desc"), ProblemType.JAVADOC_STUB_DESCRIPTION);
                }
                for (CtJavaDocTag tag : javadoc.getTags()) {
                    switch (tag.getType()) {
                        case PARAM: {
                            if (!JavadocStubCheck.this.isDefaultValueDescription(tag.getContent())) break;
                            JavadocStubCheck.this.addLocalProblem((CtElement)javadoc, new LocalizedMessage("javadoc-stub-exp-param", Map.of("param", tag.getParam())), ProblemType.JAVADOC_STUB_PARAMETER_TAG);
                            break;
                        }
                        case RETURN: {
                            if (!JavadocStubCheck.this.isDefaultValueDescription(tag.getContent())) break;
                            JavadocStubCheck.this.addLocalProblem((CtElement)javadoc, new LocalizedMessage("javadoc-stub-exp-return"), ProblemType.JAVADOC_STUB_RETURN_TAG);
                            break;
                        }
                        case THROWS: {
                            if (!JavadocStubCheck.this.isDefaultValueDescription(tag.getContent())) break;
                            JavadocStubCheck.this.addLocalProblem((CtElement)javadoc, new LocalizedMessage("javadoc-stub-exp-throws", Map.of("exp", tag.getParam())), ProblemType.JAVADOC_STUB_THROWS_TAG);
                            break;
                        }
                    }
                }
            }
        });
    }

    private boolean isDefaultValueDescription(String description) {
        return (description = description.toLowerCase().replace(".", "").replace(",", "")).isBlank() || description.equals("parameter") || description.equals("param") || description.equals("return value") || description.equals("todo") || description.equals("null") || description.equals("description") || description.equals("beschreibung") || description.trim().matches("the (bool|boolean|byte|char|short|int|integer|long|float|double|string|object|exception|array)( value| array)?");
    }
}

