/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.api;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.Translatable;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.dynamic.DynamicAnalysis;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import spoon.processing.AbstractProcessor;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtTypeAccess;
import spoon.reflect.declaration.CtElement;

@ExecutableCheck(reportedProblems={ProblemType.USE_STRING_FORMATTED})
public class UseStringFormatted
extends IntegratedCheck {
    private void checkCtInvocation(CtInvocation<?> ctInvocation) {
        boolean hasInvokedStringFormat;
        CtTypeAccess ctTypeAccess;
        CtExpression ctExpression = ctInvocation.getTarget();
        boolean bl = ctExpression instanceof CtTypeAccess && SpoonUtil.isTypeEqualTo((ctTypeAccess = (CtTypeAccess)ctExpression).getAccessedType(), String.class) && ctInvocation.getExecutable().getSimpleName().equals("format") && !ctInvocation.getArguments().isEmpty() && SpoonUtil.isTypeEqualTo(((CtExpression)ctInvocation.getArguments().get(0)).getType(), String.class) ? true : (hasInvokedStringFormat = false);
        if (!hasInvokedStringFormat) {
            return;
        }
        ArrayList args = new ArrayList(ctInvocation.getArguments());
        if (args.size() < 2) {
            return;
        }
        CtExpression format = (CtExpression)args.remove(0);
        String output = "%s.formatted(%s)".formatted(format, args.stream().map(Object::toString).reduce((a, b) -> a + ", " + b).orElse(""));
        this.addLocalProblem((CtElement)ctInvocation, (Translatable)new LocalizedMessage("use-string-formatted", Map.of("formatted", output)), ProblemType.USE_STRING_FORMATTED);
    }

    @Override
    protected void check(StaticAnalysis staticAnalysis, DynamicAnalysis dynamicAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtInvocation<?>>(){

            public void process(CtInvocation<?> ctInvocation) {
                UseStringFormatted.this.checkCtInvocation(ctInvocation);
            }
        });
    }

    @Override
    public Optional<Integer> maximumProblems() {
        return Optional.of(1);
    }
}

