/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.api;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.Translatable;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.dynamic.DynamicAnalysis;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.SpoonUtil;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.UnaryOperator;
import spoon.processing.AbstractProcessor;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtTypeAccess;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.factory.TypeFactory;
import spoon.reflect.reference.CtTypeReference;

@ExecutableCheck(reportedProblems={ProblemType.USE_FORMAT_STRING})
public class UseFormatString
extends IntegratedCheck {
    private static final int MIN_NUMBER_CONCATENATIONS = 3;
    private static final int MIN_NUMBER_LITERALS = 2;
    private static final int MAXIMUM_STRING_LENGTH_IN_LINE = 55;

    private List<CtExpression<?>> getFormatArgs(CtBinaryOperator<?> ctBinaryOperator) {
        ArrayList result = new ArrayList();
        CtExpression left = ctBinaryOperator.getLeftHandOperand();
        CtExpression right = ctBinaryOperator.getRightHandOperand();
        result.add(right);
        while (left instanceof CtBinaryOperator) {
            CtBinaryOperator lhs = (CtBinaryOperator)left;
            result.add(lhs.getRightHandOperand());
            left = lhs.getLeftHandOperand();
        }
        result.add(left);
        Collections.reverse(result);
        return result;
    }

    private String getFormatPlaceholder(CtTypeReference<?> ctTypeReference) {
        if (ctTypeReference.isPrimitive()) {
            return switch (ctTypeReference.getSimpleName()) {
                case "boolean" -> "%b";
                case "char" -> "%c";
                case "byte", "short", "int", "long" -> "%d";
                case "float", "double" -> "%f";
                default -> "%s";
            };
        }
        return "%s";
    }

    /*
     * WARNING - void declaration
     */
    private String buildFormattedString(Iterable<? extends CtExpression<?>> ctExpressions) {
        StringBuilder formatString = new StringBuilder();
        ArrayList<String> args = new ArrayList<String>();
        boolean hasInlineNewline = false;
        for (CtExpression<?> ctExpression : ctExpressions) {
            void var6_6;
            CtLiteral literal;
            CtExpression<?> ctExpression2 = SpoonUtil.resolveConstant(ctExpression);
            if (ctExpression2 instanceof CtLiteral && (literal = (CtLiteral)ctExpression2).getValue() != null && SpoonUtil.isTypeEqualTo(literal.getType(), String.class)) {
                CtLiteral ctLiteral = literal;
            }
            if (var6_6 instanceof CtLiteral) {
                CtLiteral ctLiteral = (CtLiteral)var6_6;
                CtTypeReference ctTypeInformation = ctLiteral.getType();
                Object object = ctLiteral.getValue();
                if (object instanceof String) {
                    String value = (String)object;
                    if (value.equals("\n")) {
                        hasInlineNewline = true;
                        formatString.append("%n");
                    } else {
                        formatString.append(value);
                    }
                    if (!value.endsWith("%")) continue;
                    return null;
                }
                if (!ctTypeInformation.isPrimitive() || ctTypeInformation.isArray()) continue;
                formatString.append(ctLiteral.getValue());
                continue;
            }
            formatString.append(this.getFormatPlaceholder(var6_6.getType()));
            args.add(var6_6.prettyprint());
        }
        if (args.isEmpty() && formatString.length() >= 55) {
            return null;
        }
        if (args.isEmpty() && !hasInlineNewline) {
            return "\"%s\"".formatted(formatString.toString());
        }
        if (hasInlineNewline && args.isEmpty()) {
            return null;
        }
        return "\"%s\".formatted(%s)".formatted(formatString.toString(), String.join((CharSequence)", ", args));
    }

    private CtExpression<?> resolveExpression(CtExpression<?> ctExpression) {
        CtLiteral ctLiteral;
        CtTypeAccess ctTypeAccess;
        CtInvocation ctInvocation;
        CtExpression ctExpression2;
        TypeFactory typeFactory = ctExpression.getFactory().Type();
        if (ctExpression instanceof CtInvocation && (ctExpression2 = (ctInvocation = (CtInvocation)ctExpression).getTarget()) instanceof CtTypeAccess && SpoonUtil.isTypeEqualTo((ctTypeAccess = (CtTypeAccess)ctExpression2).getAccessedType(), System.class) && SpoonUtil.isSignatureEqualTo(ctInvocation.getExecutable(), typeFactory.stringType(), "lineSeparator", new CtTypeReference[0])) {
            return SpoonUtil.makeLiteral(typeFactory.stringType(), "\n");
        }
        if (ctExpression instanceof CtLiteral && SpoonUtil.areLiteralsEqual(ctLiteral = (CtLiteral)ctExpression, SpoonUtil.makeLiteral(typeFactory.characterPrimitiveType(), Character.valueOf('\n')))) {
            return SpoonUtil.makeLiteral(typeFactory.stringType(), "\n");
        }
        return ctExpression;
    }

    private void checkArgs(CtElement ctElement, Iterable<? extends CtExpression<?>> formatArgs, UnaryOperator<String> suggestion) {
        ArrayList args = new ArrayList();
        for (CtExpression<?> expression : formatArgs) {
            args.add(this.resolveExpression(expression));
        }
        if (args.size() < 3) {
            return;
        }
        String formattedString = this.buildFormattedString(args);
        if (formattedString == null) {
            return;
        }
        this.addLocalProblem(ctElement, (Translatable)new LocalizedMessage("use-format-string", Map.of("formatted", (String)suggestion.apply(formattedString))), ProblemType.USE_FORMAT_STRING);
    }

    private void checkCtBinaryOperator(CtBinaryOperator<?> ctBinaryOperator) {
        if (ctBinaryOperator.getParent(CtBinaryOperator.class) != null) {
            return;
        }
        if (ctBinaryOperator.getKind() != BinaryOperatorKind.PLUS) {
            return;
        }
        if (!SpoonUtil.isString(ctBinaryOperator.getType())) {
            return;
        }
        List<CtExpression<?>> formatArgs = this.getFormatArgs(ctBinaryOperator);
        int numberOfLiterals = (int)formatArgs.stream().filter(ctExpression -> {
            CtLiteral literal;
            CtExpression patt8148$temp = SpoonUtil.resolveConstant(ctExpression);
            return patt8148$temp instanceof CtLiteral && (literal = (CtLiteral)patt8148$temp).getValue() != null;
        }).count();
        if (numberOfLiterals < 2) {
            return;
        }
        this.checkArgs((CtElement)ctBinaryOperator, (Iterable<? extends CtExpression<?>>)formatArgs, suggestion -> suggestion);
    }

    private void checkCtInvocation(CtInvocation<?> ctInvocation) {
        CtTypeReference stringBuilderType = ctInvocation.getFactory().Type().createReference(StringBuilder.class);
        if (!ctInvocation.getType().equals(stringBuilderType)) {
            return;
        }
        if (!ctInvocation.getExecutable().getSimpleName().equals("append")) {
            return;
        }
        if (ctInvocation.getParent(CtInvocation.class) != null) {
            return;
        }
        ArrayList formatArgs = new ArrayList();
        CtExpression invocationExpression = ctInvocation.getTarget();
        CtInvocation currentInvocation = ctInvocation;
        while (currentInvocation != null) {
            if (!currentInvocation.getExecutable().getSimpleName().equals("append")) {
                return;
            }
            List arguments = currentInvocation.getArguments();
            if (arguments.size() != 1) {
                return;
            }
            formatArgs.addAll(arguments);
            CtExpression ctExpression = currentInvocation.getTarget();
            if (ctExpression instanceof CtInvocation) {
                CtInvocation ctInvocationTarget;
                currentInvocation = ctInvocationTarget = (CtInvocation)ctExpression;
                continue;
            }
            if (!stringBuilderType.equals(currentInvocation.getTarget().getType())) {
                return;
            }
            invocationExpression = currentInvocation.getTarget();
            currentInvocation = null;
        }
        Collections.reverse(formatArgs);
        String target = invocationExpression.prettyprint();
        this.checkArgs((CtElement)ctInvocation, formatArgs, suggestion -> "%s.append(%s)".formatted(target, suggestion));
    }

    @Override
    protected void check(StaticAnalysis staticAnalysis, DynamicAnalysis dynamicAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtExpression<String>>(){

            public void process(CtExpression<String> ctExpression) {
                if (ctExpression instanceof CtBinaryOperator) {
                    CtBinaryOperator ctBinaryOperator = (CtBinaryOperator)ctExpression;
                    UseFormatString.this.checkCtBinaryOperator(ctBinaryOperator);
                } else if (ctExpression instanceof CtInvocation) {
                    CtInvocation ctInvocation = (CtInvocation)ctExpression;
                    UseFormatString.this.checkCtInvocation(ctInvocation);
                }
            }
        });
    }

    @Override
    public Optional<Integer> maximumProblems() {
        return Optional.of(1);
    }
}

