/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.core.check.api;

import de.firemage.autograder.core.LocalizedMessage;
import de.firemage.autograder.core.ProblemType;
import de.firemage.autograder.core.Translatable;
import de.firemage.autograder.core.check.ExecutableCheck;
import de.firemage.autograder.core.dynamic.DynamicAnalysis;
import de.firemage.autograder.core.integrated.IntegratedCheck;
import de.firemage.autograder.core.integrated.StaticAnalysis;
import spoon.processing.AbstractProcessor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtTypedElement;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.reference.CtTypeReference;

@ExecutableCheck(reportedProblems={ProblemType.OPTIONAL_TRI_STATE, ProblemType.OPTIONAL_ARGUMENT})
public class OptionalBadPractices
extends IntegratedCheck {
    private void checkCtVariable(CtTypedElement<?> ctTypedElement) {
        boolean isTriState;
        CtTypeReference ctTypeReference = ctTypedElement.getType();
        if (ctTypeReference == null || ctTypeReference.isImplicit() || !ctTypeReference.getPosition().isValidPosition()) {
            return;
        }
        if (!ctTypeReference.getQualifiedName().equals("java.util.Optional")) {
            return;
        }
        if (ctTypedElement instanceof CtParameter) {
            this.addLocalProblem((CtElement)ctTypeReference, (Translatable)new LocalizedMessage("optional-argument"), ProblemType.OPTIONAL_ARGUMENT);
        }
        if (isTriState = ctTypeReference.getActualTypeArguments().stream().anyMatch(x -> x.equals(ctTypeReference.getFactory().Type().createReference(Boolean.class)))) {
            this.addLocalProblem((CtElement)ctTypeReference, (Translatable)new LocalizedMessage("optional-tri-state"), ProblemType.OPTIONAL_TRI_STATE);
        }
    }

    @Override
    protected void check(StaticAnalysis staticAnalysis, DynamicAnalysis dynamicAnalysis) {
        staticAnalysis.processWith(new AbstractProcessor<CtTypedElement<?>>(){

            public void process(CtTypedElement<?> ctTypedElement) {
                if (ctTypedElement.isImplicit() || !ctTypedElement.getPosition().isValidPosition()) {
                    return;
                }
                if (ctTypedElement instanceof CtVariable || ctTypedElement instanceof CtMethod) {
                    OptionalBadPractices.this.checkCtVariable(ctTypedElement);
                }
            }
        });
    }
}

